rule win_medusa_http_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.medusa_http."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.medusa_http"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e1fb 1cc9 3ca5 2c8e a1???????? d528 }
            // n = 6, score = 100
            //   e1fb                 | loope               0xfffffffd
            //   1cc9                 | sbb                 al, 0xc9
            //   3ca5                 | cmp                 al, 0xa5
            //   2c8e                 | sub                 al, 0x8e
            //   a1????????           |                     
            //   d528                 | aad                 0x28

        $sequence_1 = { ff7100 52 ff7200 53 ff7300 54 }
            // n = 6, score = 100
            //   ff7100               | push                dword ptr [ecx]
            //   52                   | push                edx
            //   ff7200               | push                dword ptr [edx]
            //   53                   | push                ebx
            //   ff7300               | push                dword ptr [ebx]
            //   54                   | push                esp

        $sequence_2 = { 6a00 4b ff6b00 4c ff6c004d ff6d00 4e }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   4b                   | dec                 ebx
            //   ff6b00               | ljmp                [ebx]
            //   4c                   | dec                 esp
            //   ff6c004d             | ljmp                [eax + eax + 0x4d]
            //   ff6d00               | ljmp                [ebp]
            //   4e                   | dec                 esi

        $sequence_3 = { 0050ff 7000 51 ff7100 }
            // n = 4, score = 100
            //   0050ff               | add                 byte ptr [eax - 1], dl
            //   7000                 | jo                  2
            //   51                   | push                ecx
            //   ff7100               | push                dword ptr [ecx]

        $sequence_4 = { 53 ff7300 54 ff740055 ff7500 56 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   ff7300               | push                dword ptr [ebx]
            //   54                   | push                esp
            //   ff740055             | push                dword ptr [eax + eax + 0x55]
            //   ff7500               | push                dword ptr [ebp]
            //   56                   | push                esi

        $sequence_5 = { 8b4c6386 8608 5f e1fb 1cc9 3ca5 2c8e }
            // n = 7, score = 100
            //   8b4c6386             | mov                 ecx, dword ptr [ebx - 0x7a]
            //   8608                 | xchg                byte ptr [eax], cl
            //   5f                   | pop                 edi
            //   e1fb                 | loope               0xfffffffd
            //   1cc9                 | sbb                 al, 0xc9
            //   3ca5                 | cmp                 al, 0xa5
            //   2c8e                 | sub                 al, 0x8e

        $sequence_6 = { 0c48 b5f9 43 324dd5 1ddf859f31 }
            // n = 5, score = 100
            //   0c48                 | or                  al, 0x48
            //   b5f9                 | mov                 ch, 0xf9
            //   43                   | inc                 ebx
            //   324dd5               | xor                 cl, byte ptr [ebp - 0x2b]
            //   1ddf859f31           | sbb                 eax, 0x319f85df

        $sequence_7 = { 0000 aa 05854cffab 004893 }
            // n = 4, score = 100
            //   0000                 | add                 byte ptr [eax], al
            //   aa                   | stosb               byte ptr es:[edi], al
            //   05854cffab           | add                 eax, 0xabff4c85
            //   004893               | add                 byte ptr [eax - 0x6d], cl

        $sequence_8 = { 05854cffab 004893 3eb35b 813bf80937dc 8b4c6386 }
            // n = 5, score = 100
            //   05854cffab           | add                 eax, 0xabff4c85
            //   004893               | add                 byte ptr [eax - 0x6d], cl
            //   3eb35b               | mov                 bl, 0x5b
            //   813bf80937dc         | cmp                 dword ptr [ebx], 0xdc3709f8
            //   8b4c6386             | mov                 ecx, dword ptr [ebx - 0x7a]

        $sequence_9 = { 1cc9 3ca5 2c8e a1???????? d528 32f4 }
            // n = 6, score = 100
            //   1cc9                 | sbb                 al, 0xc9
            //   3ca5                 | cmp                 al, 0xa5
            //   2c8e                 | sub                 al, 0x8e
            //   a1????????           |                     
            //   d528                 | aad                 0x28
            //   32f4                 | xor                 dh, ah

    condition:
        7 of them and filesize < 1720320
}