rule win_meow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.meow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.meow"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c68561ffffff16 c68562ffffff23 c68563ffffff12 c68564ffffff23 c68565ffffff70 c68566ffffff23 }
            // n = 6, score = 100
            //   c68561ffffff16       | mov                 byte ptr [ebp - 0x9f], 0x16
            //   c68562ffffff23       | mov                 byte ptr [ebp - 0x9e], 0x23
            //   c68563ffffff12       | mov                 byte ptr [ebp - 0x9d], 0x12
            //   c68564ffffff23       | mov                 byte ptr [ebp - 0x9c], 0x23
            //   c68565ffffff70       | mov                 byte ptr [ebp - 0x9b], 0x70
            //   c68566ffffff23       | mov                 byte ptr [ebp - 0x9a], 0x23

        $sequence_1 = { 8985ccfdffff 85c0 0f8431020000 8b483c 03c8 0fb74118 3b85c4fdffff }
            // n = 7, score = 100
            //   8985ccfdffff         | mov                 dword ptr [ebp - 0x234], eax
            //   85c0                 | test                eax, eax
            //   0f8431020000         | je                  0x237
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]
            //   03c8                 | add                 ecx, eax
            //   0fb74118             | movzx               eax, word ptr [ecx + 0x18]
            //   3b85c4fdffff         | cmp                 eax, dword ptr [ebp - 0x23c]

        $sequence_2 = { 7431 b802000000 2bc1 0345f0 8945f0 8b45f0 99 }
            // n = 7, score = 100
            //   7431                 | je                  0x33
            //   b802000000           | mov                 eax, 2
            //   2bc1                 | sub                 eax, ecx
            //   0345f0               | add                 eax, dword ptr [ebp - 0x10]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   99                   | cdq                 

        $sequence_3 = { f7fb 88540df1 41 83f90a 72de 8d45f1 898588feffff }
            // n = 7, score = 100
            //   f7fb                 | idiv                ebx
            //   88540df1             | mov                 byte ptr [ebp + ecx - 0xf], dl
            //   41                   | inc                 ecx
            //   83f90a               | cmp                 ecx, 0xa
            //   72de                 | jb                  0xffffffe0
            //   8d45f1               | lea                 eax, [ebp - 0xf]
            //   898588feffff         | mov                 dword ptr [ebp - 0x178], eax

        $sequence_4 = { 33c5 8945fc 53 56 0f57c0 894de8 33f6 }
            // n = 7, score = 100
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   56                   | push                esi
            //   0f57c0               | xorps               xmm0, xmm0
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   33f6                 | xor                 esi, esi

        $sequence_5 = { 83c408 eb35 0fb605???????? b225 50 }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   eb35                 | jmp                 0x37
            //   0fb605????????       |                     
            //   b225                 | mov                 dl, 0x25
            //   50                   | push                eax

        $sequence_6 = { 51 52 e8???????? 83c408 8b8c24f4050000 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b8c24f4050000       | mov                 ecx, dword ptr [esp + 0x5f4]

        $sequence_7 = { 6849372c4f ba0f000000 8d1c3f e8???????? 83c408 68???????? }
            // n = 6, score = 100
            //   6849372c4f           | push                0x4f2c3749
            //   ba0f000000           | mov                 edx, 0xf
            //   8d1c3f               | lea                 ebx, [edi + edi]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   68????????           |                     

        $sequence_8 = { 7415 83e801 0f8595010000 c745e498024300 e9???????? 894de0 }
            // n = 6, score = 100
            //   7415                 | je                  0x17
            //   83e801               | sub                 eax, 1
            //   0f8595010000         | jne                 0x19b
            //   c745e498024300       | mov                 dword ptr [ebp - 0x1c], 0x430298
            //   e9????????           |                     
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx

        $sequence_9 = { 8bf7 8d7b75 0f1f4000 8a06 8d7601 0fb6c8 83e953 }
            // n = 7, score = 100
            //   8bf7                 | mov                 esi, edi
            //   8d7b75               | lea                 edi, [ebx + 0x75]
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8a06                 | mov                 al, byte ptr [esi]
            //   8d7601               | lea                 esi, [esi + 1]
            //   0fb6c8               | movzx               ecx, al
            //   83e953               | sub                 ecx, 0x53

    condition:
        7 of them and filesize < 492544
}