rule win_merdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.merdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.merdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41 0fb7c0 47 663102 83c202 6683f908 72cf }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   0fb7c0               | movzx               eax, ax
            //   47                   | inc                 edi
            //   663102               | xor                 word ptr [edx], ax
            //   83c202               | add                 edx, 2
            //   6683f908             | cmp                 cx, 8
            //   72cf                 | jb                  0xffffffd1

        $sequence_1 = { e8???????? 83c40c 8934fd78f30110 eb07 56 e8???????? 59 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8934fd78f30110       | mov                 dword ptr [edi*8 + 0x1001f378], esi
            //   eb07                 | jmp                 9
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { 5d c20400 c7875404000001000000 8b07 }
            // n = 4, score = 100
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   c7875404000001000000     | mov    dword ptr [edi + 0x454], 1
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_3 = { 8d4590 50 8d45a4 50 ff15???????? }
            // n = 5, score = 100
            //   8d4590               | lea                 eax, [ebp - 0x70]
            //   50                   | push                eax
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 75f9 2bca 51 8d85acfeffff 50 8d8d7cfcffff e8???????? }
            // n = 7, score = 100
            //   75f9                 | jne                 0xfffffffb
            //   2bca                 | sub                 ecx, edx
            //   51                   | push                ecx
            //   8d85acfeffff         | lea                 eax, [ebp - 0x154]
            //   50                   | push                eax
            //   8d8d7cfcffff         | lea                 ecx, [ebp - 0x384]
            //   e8????????           |                     

        $sequence_5 = { b91a000000 f7f9 80c261 eb10 e8???????? 99 }
            // n = 6, score = 100
            //   b91a000000           | mov                 ecx, 0x1a
            //   f7f9                 | idiv                ecx
            //   80c261               | add                 dl, 0x61
            //   eb10                 | jmp                 0x12
            //   e8????????           |                     
            //   99                   | cdq                 

        $sequence_6 = { e8???????? 8987e4020000 c645fc02 8d55c0 b8fe000000 c745c0a3008d00 33c9 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8987e4020000         | mov                 dword ptr [edi + 0x2e4], eax
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8d55c0               | lea                 edx, [ebp - 0x40]
            //   b8fe000000           | mov                 eax, 0xfe
            //   c745c0a3008d00       | mov                 dword ptr [ebp - 0x40], 0x8d00a3
            //   33c9                 | xor                 ecx, ecx

        $sequence_7 = { 8dbb78030000 c785dcfdffff01000000 7204 8b07 eb02 8bc7 }
            // n = 6, score = 100
            //   8dbb78030000         | lea                 edi, [ebx + 0x378]
            //   c785dcfdffff01000000     | mov    dword ptr [ebp - 0x224], 1
            //   7204                 | jb                  6
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi

        $sequence_8 = { e8???????? 8987e4020000 c645fc02 8d55c0 b8fe000000 c745c0a3008d00 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8987e4020000         | mov                 dword ptr [edi + 0x2e4], eax
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8d55c0               | lea                 edx, [ebp - 0x40]
            //   b8fe000000           | mov                 eax, 0xfe
            //   c745c0a3008d00       | mov                 dword ptr [ebp - 0x40], 0x8d00a3

        $sequence_9 = { 8b7310 8d4310 8b11 51 50 8d4508 }
            // n = 6, score = 100
            //   8b7310               | mov                 esi, dword ptr [ebx + 0x10]
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]

    condition:
        7 of them and filesize < 307200
}