rule win_mespinoza_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mespinoza."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mespinoza"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a02 6a00 68???????? 6802000080 ff15???????? 8b15???????? }
            // n = 6, score = 200
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   68????????           |                     
            //   6802000080           | push                0x80000002
            //   ff15????????         |                     
            //   8b15????????         |                     

        $sequence_1 = { 894de4 399860554700 0f84ea000000 41 83c030 894de4 3df0000000 }
            // n = 7, score = 200
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   399860554700         | cmp                 dword ptr [eax + 0x475560], ebx
            //   0f84ea000000         | je                  0xf0
            //   41                   | inc                 ecx
            //   83c030               | add                 eax, 0x30
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   3df0000000           | cmp                 eax, 0xf0

        $sequence_2 = { 6a00 ff5014 c20800 55 8bec 83c1f8 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   ff5014               | call                dword ptr [eax + 0x14]
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c1f8               | add                 ecx, -8

        $sequence_3 = { 40 8945d4 8bd8 0f1f00 ff75e0 8b17 }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8bd8                 | mov                 ebx, eax
            //   0f1f00               | nop                 dword ptr [eax]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   8b17                 | mov                 edx, dword ptr [edi]

        $sequence_4 = { e8???????? 8d8d98efffff e8???????? 8b4df4 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8d8d98efffff         | lea                 ecx, [ebp - 0x1068]
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_5 = { 897de4 33db 895dfc 895dd4 81fb80000000 7d4d 8b049d00b04700 }
            // n = 7, score = 200
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   33db                 | xor                 ebx, ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   81fb80000000         | cmp                 ebx, 0x80
            //   7d4d                 | jge                 0x4f
            //   8b049d00b04700       | mov                 eax, dword ptr [ebx*4 + 0x47b000]

        $sequence_6 = { 3347fc 0be8 83ea01 75f0 8b5c2420 896c2410 eb08 }
            // n = 7, score = 200
            //   3347fc               | xor                 eax, dword ptr [edi - 4]
            //   0be8                 | or                  ebp, eax
            //   83ea01               | sub                 edx, 1
            //   75f0                 | jne                 0xfffffff2
            //   8b5c2420             | mov                 ebx, dword ptr [esp + 0x20]
            //   896c2410             | mov                 dword ptr [esp + 0x10], ebp
            //   eb08                 | jmp                 0xa

        $sequence_7 = { c6430900 83630c00 c703???????? 8a00 884310 eb02 33db }
            // n = 7, score = 200
            //   c6430900             | mov                 byte ptr [ebx + 9], 0
            //   83630c00             | and                 dword ptr [ebx + 0xc], 0
            //   c703????????         |                     
            //   8a00                 | mov                 al, byte ptr [eax]
            //   884310               | mov                 byte ptr [ebx + 0x10], al
            //   eb02                 | jmp                 4
            //   33db                 | xor                 ebx, ebx

        $sequence_8 = { 0f57c0 c745fc00000000 660fd64604 6aff 8d4e10 c706???????? c7460c04000000 }
            // n = 7, score = 200
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   660fd64604           | movq                qword ptr [esi + 4], xmm0
            //   6aff                 | push                -1
            //   8d4e10               | lea                 ecx, [esi + 0x10]
            //   c706????????         |                     
            //   c7460c04000000       | mov                 dword ptr [esi + 0xc], 4

        $sequence_9 = { e8???????? 8bd8 33c9 8bc6 895dc8 f7e7 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   33c9                 | xor                 ecx, ecx
            //   8bc6                 | mov                 eax, esi
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   f7e7                 | mul                 edi

    condition:
        7 of them and filesize < 1091584
}