rule win_metadatabin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.metadatabin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.metadatabin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d9424b8000000 e8???????? 83bc248800000005 0f848d010000 f20f108c2498000000 f20f108424a0000000 f20f10942488000000 }
            // n = 7, score = 100
            //   8d9424b8000000       | lea                 edx, [esp + 0xb8]
            //   e8????????           |                     
            //   83bc248800000005     | cmp                 dword ptr [esp + 0x88], 5
            //   0f848d010000         | je                  0x193
            //   f20f108c2498000000     | movsd    xmm1, qword ptr [esp + 0x98]
            //   f20f108424a0000000     | movsd    xmm0, qword ptr [esp + 0xa0]
            //   f20f10942488000000     | movsd    xmm2, qword ptr [esp + 0x88]

        $sequence_1 = { c745e4c0834000 894dd0 8d4dc0 c745d402000000 89c2 897de8 8975ec }
            // n = 7, score = 100
            //   c745e4c0834000       | mov                 dword ptr [ebp - 0x1c], 0x4083c0
            //   894dd0               | mov                 dword ptr [ebp - 0x30], ecx
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   c745d402000000       | mov                 dword ptr [ebp - 0x2c], 2
            //   89c2                 | mov                 edx, eax
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi

        $sequence_2 = { b911000000 89df f3a5 f20f108c2474050000 f20f1094246c050000 f20f1084247c050000 f20f118c24b8030000 }
            // n = 7, score = 100
            //   b911000000           | mov                 ecx, 0x11
            //   89df                 | mov                 edi, ebx
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   f20f108c2474050000     | movsd    xmm1, qword ptr [esp + 0x574]
            //   f20f1094246c050000     | movsd    xmm2, qword ptr [esp + 0x56c]
            //   f20f1084247c050000     | movsd    xmm0, qword ptr [esp + 0x57c]
            //   f20f118c24b8030000     | movsd    qword ptr [esp + 0x3b8], xmm1

        $sequence_3 = { b001 84c9 0f859cfeffff 8b461c 6a01 68???????? ff7618 }
            // n = 7, score = 100
            //   b001                 | mov                 al, 1
            //   84c9                 | test                cl, cl
            //   0f859cfeffff         | jne                 0xfffffea2
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   6a01                 | push                1
            //   68????????           |                     
            //   ff7618               | push                dword ptr [esi + 0x18]

        $sequence_4 = { 8b470c 83780400 7421 8b5f08 83780809 7308 e8???????? }
            // n = 7, score = 100
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   83780400             | cmp                 dword ptr [eax + 4], 0
            //   7421                 | je                  0x23
            //   8b5f08               | mov                 ebx, dword ptr [edi + 8]
            //   83780809             | cmp                 dword ptr [eax + 8], 9
            //   7308                 | jae                 0xa
            //   e8????????           |                     

        $sequence_5 = { ff76fc e9???????? 0fb64e2c 85c9 0f84a2000000 83f903 0f84b2000000 }
            // n = 7, score = 100
            //   ff76fc               | push                dword ptr [esi - 4]
            //   e9????????           |                     
            //   0fb64e2c             | movzx               ecx, byte ptr [esi + 0x2c]
            //   85c9                 | test                ecx, ecx
            //   0f84a2000000         | je                  0xa8
            //   83f903               | cmp                 ecx, 3
            //   0f84b2000000         | je                  0xb8

        $sequence_6 = { e8???????? 0f0b 660f1f840000000000 55 89e5 83ec08 8b4508 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f0b                 | ud2                 
            //   660f1f840000000000     | nop    word ptr [eax + eax]
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 8a4220 0f1002 8b4a10 8b5214 8845dc 8d45e0 0f1145bc }
            // n = 7, score = 100
            //   8a4220               | mov                 al, byte ptr [edx + 0x20]
            //   0f1002               | movups              xmm0, xmmword ptr [edx]
            //   8b4a10               | mov                 ecx, dword ptr [edx + 0x10]
            //   8b5214               | mov                 edx, dword ptr [edx + 0x14]
            //   8845dc               | mov                 byte ptr [ebp - 0x24], al
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   0f1145bc             | movups              xmmword ptr [ebp - 0x44], xmm0

        $sequence_8 = { c68424010c000000 c78424c00b00003e000000 c68424020c000000 c78424c00b00003f000000 c68424030c000000 c78424c00b000040000000 8db424c00b0000 }
            // n = 7, score = 100
            //   c68424010c000000     | mov                 byte ptr [esp + 0xc01], 0
            //   c78424c00b00003e000000     | mov    dword ptr [esp + 0xbc0], 0x3e
            //   c68424020c000000     | mov                 byte ptr [esp + 0xc02], 0
            //   c78424c00b00003f000000     | mov    dword ptr [esp + 0xbc0], 0x3f
            //   c68424030c000000     | mov                 byte ptr [esp + 0xc03], 0
            //   c78424c00b000040000000     | mov    dword ptr [esp + 0xbc0], 0x40
            //   8db424c00b0000       | lea                 esi, [esp + 0xbc0]

        $sequence_9 = { 89de 8b9c24a0020000 135c2478 13542424 138424a0000000 03bc2430010000 135c2414 }
            // n = 7, score = 100
            //   89de                 | mov                 esi, ebx
            //   8b9c24a0020000       | mov                 ebx, dword ptr [esp + 0x2a0]
            //   135c2478             | adc                 ebx, dword ptr [esp + 0x78]
            //   13542424             | adc                 edx, dword ptr [esp + 0x24]
            //   138424a0000000       | adc                 eax, dword ptr [esp + 0xa0]
            //   03bc2430010000       | add                 edi, dword ptr [esp + 0x130]
            //   135c2414             | adc                 ebx, dword ptr [esp + 0x14]

    condition:
        7 of them and filesize < 1263616
}