rule win_metastealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.metastealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.metastealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f30f59c3 f30f584104 f30f114104 0f28c1 f30f584108 f30f584918 f30f59c3 }
            // n = 7, score = 300
            //   f30f59c3             | mulss               xmm0, xmm3
            //   f30f584104           | addss               xmm0, dword ptr [ecx + 4]
            //   f30f114104           | movss               dword ptr [ecx + 4], xmm0
            //   0f28c1               | movaps              xmm0, xmm1
            //   f30f584108           | addss               xmm0, dword ptr [ecx + 8]
            //   f30f584918           | addss               xmm1, dword ptr [ecx + 0x18]
            //   f30f59c3             | mulss               xmm0, xmm3

        $sequence_1 = { f3a5 68???????? 66a5 c680b600000000 e8???????? 68???????? e8???????? }
            // n = 7, score = 300
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   68????????           |                     
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   c680b600000000       | mov                 byte ptr [eax + 0xb6], 0
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_2 = { ffb6a8000000 8d86d8000000 50 56 e8???????? 83c410 f7d8 }
            // n = 7, score = 300
            //   ffb6a8000000         | push                dword ptr [esi + 0xa8]
            //   8d86d8000000         | lea                 eax, [esi + 0xd8]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   f7d8                 | neg                 eax

        $sequence_3 = { f30f59cb f30f5c662c f30f101d???????? f30f5c4e28 f30f1150f8 f30f59e2 f30f59ca }
            // n = 7, score = 300
            //   f30f59cb             | mulss               xmm1, xmm3
            //   f30f5c662c           | subss               xmm4, dword ptr [esi + 0x2c]
            //   f30f101d????????     |                     
            //   f30f5c4e28           | subss               xmm1, dword ptr [esi + 0x28]
            //   f30f1150f8           | movss               dword ptr [eax - 8], xmm2
            //   f30f59e2             | mulss               xmm4, xmm2
            //   f30f59ca             | mulss               xmm1, xmm2

        $sequence_4 = { ff7624 e8???????? 83c404 894654 85c0 7412 0f57c0 }
            // n = 7, score = 300
            //   ff7624               | push                dword ptr [esi + 0x24]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   894654               | mov                 dword ptr [esi + 0x54], eax
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14
            //   0f57c0               | xorps               xmm0, xmm0

        $sequence_5 = { f30f5dc3 f30f107804 f30f102d???????? f20f1035???????? f30f59d3 f30f59c5 f30f5ed7 }
            // n = 7, score = 300
            //   f30f5dc3             | minss               xmm0, xmm3
            //   f30f107804           | movss               xmm7, dword ptr [eax + 4]
            //   f30f102d????????     |                     
            //   f20f1035????????     |                     
            //   f30f59d3             | mulss               xmm2, xmm3
            //   f30f59c5             | mulss               xmm0, xmm5
            //   f30f5ed7             | divss               xmm2, xmm7

        $sequence_6 = { f20f101d???????? f20f1025???????? f20f102d???????? f20f1035???????? f20f103d???????? 8b5508 8b45fc }
            // n = 7, score = 300
            //   f20f101d????????     |                     
            //   f20f1025????????     |                     
            //   f20f102d????????     |                     
            //   f20f1035????????     |                     
            //   f20f103d????????     |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_7 = { ffd0 8bd8 83c40c 807d0c00 899f88010000 895df8 c703???????? }
            // n = 7, score = 300
            //   ffd0                 | call                eax
            //   8bd8                 | mov                 ebx, eax
            //   83c40c               | add                 esp, 0xc
            //   807d0c00             | cmp                 byte ptr [ebp + 0xc], 0
            //   899f88010000         | mov                 dword ptr [edi + 0x188], ebx
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   c703????????         |                     

        $sequence_8 = { e8???????? 6a02 8d4704 83c302 50 53 e8???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   6a02                 | push                2
            //   8d4704               | lea                 eax, [edi + 4]
            //   83c302               | add                 ebx, 2
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_9 = { ffd0 83c404 85c0 7423 8b8690010000 80781100 74e8 }
            // n = 7, score = 300
            //   ffd0                 | call                eax
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7423                 | je                  0x25
            //   8b8690010000         | mov                 eax, dword ptr [esi + 0x190]
            //   80781100             | cmp                 byte ptr [eax + 0x11], 0
            //   74e8                 | je                  0xffffffea

    condition:
        7 of them and filesize < 26230784
}