rule win_meterpreter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.meterpreter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.meterpreter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7b5d c7400800000000 8b561c c7420c00000000 }
            // n = 4, score = 200
            //   7b5d                 | jnp                 0x5f
            //   c7400800000000       | mov                 dword ptr [eax + 8], 0
            //   8b561c               | mov                 edx, dword ptr [esi + 0x1c]
            //   c7420c00000000       | mov                 dword ptr [edx + 0xc], 0

        $sequence_1 = { c07d14eb 8b542472 8cd0 f733 ce }
            // n = 5, score = 200
            //   c07d14eb             | sar                 byte ptr [ebp + 0x14], 0xeb
            //   8b542472             | mov                 edx, dword ptr [esp + 0x72]
            //   8cd0                 | mov                 eax, ss
            //   f733                 | div                 dword ptr [ebx]
            //   ce                   | into                

        $sequence_2 = { 56 e8???????? 85d9 f5 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   85d9                 | test                ecx, ebx
            //   f5                   | cmc                 

        $sequence_3 = { e04f 1089471c8b8e 48 e600 00ee }
            // n = 5, score = 200
            //   e04f                 | loopne              0x51
            //   1089471c8b8e         | adc                 byte ptr [ecx - 0x7174e3b9], cl
            //   48                   | dec                 eax
            //   e600                 | out                 0, al
            //   00ee                 | add                 dh, ch

        $sequence_4 = { 0000 68ffff0000 52 ffd7 8b2410 }
            // n = 5, score = 200
            //   0000                 | add                 byte ptr [eax], al
            //   68ffff0000           | push                0xffff
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8b2410               | mov                 esp, dword ptr [eax + edx]

        $sequence_5 = { 02c0 8bf7 b94c000061 f3ab 8b4573 8b4d0c 8bbdfc89068b }
            // n = 7, score = 200
            //   02c0                 | add                 al, al
            //   8bf7                 | mov                 esi, edi
            //   b94c000061           | mov                 ecx, 0x6100004c
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b4573               | mov                 eax, dword ptr [ebp + 0x73]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8bbdfc89068b         | mov                 edi, dword ptr [ebp - 0x74f97604]

        $sequence_6 = { 57 57 897810 57 }
            // n = 4, score = 200
            //   57                   | push                edi
            //   57                   | push                edi
            //   897810               | mov                 dword ptr [eax + 0x10], edi
            //   57                   | push                edi

        $sequence_7 = { 8d919248b299 40 93 49 722f }
            // n = 5, score = 200
            //   8d919248b299         | lea                 edx, [ecx - 0x664db76e]
            //   40                   | inc                 eax
            //   93                   | xchg                eax, ebx
            //   49                   | dec                 ecx
            //   722f                 | jb                  0x31

        $sequence_8 = { 8b3c87 1485 c9 896375 8b3b }
            // n = 5, score = 200
            //   8b3c87               | mov                 edi, dword ptr [edi + eax*4]
            //   1485                 | adc                 al, 0x85
            //   c9                   | leave               
            //   896375               | mov                 dword ptr [ebx + 0x75], esp
            //   8b3b                 | mov                 edi, dword ptr [ebx]

        $sequence_9 = { d040f3 27 c0eb80 d440 0075cc b8???????? }
            // n = 6, score = 200
            //   d040f3               | rol                 byte ptr [eax - 0xd], 1
            //   27                   | daa                 
            //   c0eb80               | shr                 bl, 0x80
            //   d440                 | aam                 0x40
            //   0075cc               | add                 byte ptr [ebp - 0x34], dh
            //   b8????????           |                     

    condition:
        7 of them and filesize < 188416
}