rule win_mewsei_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mewsei."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mewsei"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 037dfc 897df0 0fb6780b c1e708 }
            // n = 4, score = 400
            //   037dfc               | add                 edi, dword ptr [ebp - 4]
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   0fb6780b             | movzx               edi, byte ptr [eax + 0xb]
            //   c1e708               | shl                 edi, 8

        $sequence_1 = { c1e708 0fb6582c 0bfb 89b984000000 897dbc 8b7df0 337dfc }
            // n = 7, score = 400
            //   c1e708               | shl                 edi, 8
            //   0fb6582c             | movzx               ebx, byte ptr [eax + 0x2c]
            //   0bfb                 | or                  edi, ebx
            //   89b984000000         | mov                 dword ptr [ecx + 0x84], edi
            //   897dbc               | mov                 dword ptr [ebp - 0x44], edi
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   337dfc               | xor                 edi, dword ptr [ebp - 4]

        $sequence_2 = { 03de 8dbc3b56b7c7e8 0fb6580a c1c70c 037dfc 897df0 0fb6780b }
            // n = 7, score = 400
            //   03de                 | add                 ebx, esi
            //   8dbc3b56b7c7e8       | lea                 edi, [ebx + edi - 0x173848aa]
            //   0fb6580a             | movzx               ebx, byte ptr [eax + 0xa]
            //   c1c70c               | rol                 edi, 0xc
            //   037dfc               | add                 edi, dword ptr [ebp - 4]
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   0fb6780b             | movzx               edi, byte ptr [eax + 0xb]

        $sequence_3 = { 0f8278ffffff 5b 5f 8bc6 5e }
            // n = 5, score = 400
            //   0f8278ffffff         | jb                  0xffffff7e
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_4 = { 3bcf 7319 bf???????? 8d5101 2bf9 }
            // n = 5, score = 400
            //   3bcf                 | cmp                 ecx, edi
            //   7319                 | jae                 0x1b
            //   bf????????           |                     
            //   8d5101               | lea                 edx, [ecx + 1]
            //   2bf9                 | sub                 edi, ecx

        $sequence_5 = { c3 8b4d0c 85c9 7411 8bc1 }
            // n = 5, score = 400
            //   c3                   | ret                 
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   85c9                 | test                ecx, ecx
            //   7411                 | je                  0x13
            //   8bc1                 | mov                 eax, ecx

        $sequence_6 = { 6a00 50 68???????? 6a00 6a00 ffd6 50 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   50                   | push                eax
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ffd6                 | call                esi
            //   50                   | push                eax

        $sequence_7 = { 8b08 8b511c 50 ffd2 3bc3 740a 83f801 }
            // n = 7, score = 400
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b511c               | mov                 edx, dword ptr [ecx + 0x1c]
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   3bc3                 | cmp                 eax, ebx
            //   740a                 | je                  0xc
            //   83f801               | cmp                 eax, 1

        $sequence_8 = { 33d2 25ff7f0000 f7f1 80c230 885305 c6430600 85ff }
            // n = 7, score = 400
            //   33d2                 | xor                 edx, edx
            //   25ff7f0000           | and                 eax, 0x7fff
            //   f7f1                 | div                 ecx
            //   80c230               | add                 dl, 0x30
            //   885305               | mov                 byte ptr [ebx + 5], dl
            //   c6430600             | mov                 byte ptr [ebx + 6], 0
            //   85ff                 | test                edi, edi

        $sequence_9 = { c1ea10 884708 8b4610 884f05 885706 8bc8 8bd0 }
            // n = 7, score = 400
            //   c1ea10               | shr                 edx, 0x10
            //   884708               | mov                 byte ptr [edi + 8], al
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   884f05               | mov                 byte ptr [edi + 5], cl
            //   885706               | mov                 byte ptr [edi + 6], dl
            //   8bc8                 | mov                 ecx, eax
            //   8bd0                 | mov                 edx, eax

    condition:
        7 of them and filesize < 504832
}