rule win_micrass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.micrass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.micrass"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 33db 53 6801001f00 ff15???????? 3bc3 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   6801001f00           | push                0x1f0001
            //   ff15????????         |                     
            //   3bc3                 | cmp                 eax, ebx

        $sequence_1 = { 770f 0fb7c2 0fbe80e8014100 83e00f eb02 }
            // n = 5, score = 100
            //   770f                 | ja                  0x11
            //   0fb7c2               | movzx               eax, dx
            //   0fbe80e8014100       | movsx               eax, byte ptr [eax + 0x4101e8]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4

        $sequence_2 = { c1f905 8d3c8da0dd4000 8bf0 83e61f c1e606 }
            // n = 5, score = 100
            //   c1f905               | sar                 ecx, 5
            //   8d3c8da0dd4000       | lea                 edi, [ecx*4 + 0x40dda0]
            //   8bf0                 | mov                 esi, eax
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6

        $sequence_3 = { 50 8d85c03fffff 50 e8???????? 59 59 85c0 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d85c03fffff         | lea                 eax, [ebp - 0xc040]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_4 = { a1???????? 33c5 8945fc ff7508 8d85e04fffff 56 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d85e04fffff         | lea                 eax, [ebp - 0xb020]
            //   56                   | push                esi

        $sequence_5 = { 56 50 e8???????? 8b85e44fffff 83c40c }
            // n = 5, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b85e44fffff         | mov                 eax, dword ptr [ebp - 0xb01c]
            //   83c40c               | add                 esp, 0xc

        $sequence_6 = { c1f905 8b0c8da0dd4000 83e01f c1e006 f644080401 74cd }
            // n = 6, score = 100
            //   c1f905               | sar                 ecx, 5
            //   8b0c8da0dd4000       | mov                 ecx, dword ptr [ecx*4 + 0x40dda0]
            //   83e01f               | and                 eax, 0x1f
            //   c1e006               | shl                 eax, 6
            //   f644080401           | test                byte ptr [eax + ecx + 4], 1
            //   74cd                 | je                  0xffffffcf

        $sequence_7 = { c785fcfefffff4f4f4f4 c78500fffffff4f4f4f4 c78504fffffff4f4f4f4 c78508fffffff4f4f4f4 }
            // n = 4, score = 100
            //   c785fcfefffff4f4f4f4     | mov    dword ptr [ebp - 0x104], 0xf4f4f4f4
            //   c78500fffffff4f4f4f4     | mov    dword ptr [ebp - 0x100], 0xf4f4f4f4
            //   c78504fffffff4f4f4f4     | mov    dword ptr [ebp - 0xfc], 0xf4f4f4f4
            //   c78508fffffff4f4f4f4     | mov    dword ptr [ebp - 0xf8], 0xf4f4f4f4

        $sequence_8 = { c745a0808084b7 c745a4989b8791 c745a8bc959a90 c745ac9891f4f4 c745b0f4f4f4f4 c745b4f4f4f4f4 }
            // n = 6, score = 100
            //   c745a0808084b7       | mov                 dword ptr [ebp - 0x60], 0xb7848080
            //   c745a4989b8791       | mov                 dword ptr [ebp - 0x5c], 0x91879b98
            //   c745a8bc959a90       | mov                 dword ptr [ebp - 0x58], 0x909a95bc
            //   c745ac9891f4f4       | mov                 dword ptr [ebp - 0x54], 0xf4f49198
            //   c745b0f4f4f4f4       | mov                 dword ptr [ebp - 0x50], 0xf4f4f4f4
            //   c745b4f4f4f4f4       | mov                 dword ptr [ebp - 0x4c], 0xf4f4f4f4

        $sequence_9 = { c745b8f4f4f4f4 c745bcf4f4f4f4 c745c0f4f4f4f4 c745c4f4f4f4f4 }
            // n = 4, score = 100
            //   c745b8f4f4f4f4       | mov                 dword ptr [ebp - 0x48], 0xf4f4f4f4
            //   c745bcf4f4f4f4       | mov                 dword ptr [ebp - 0x44], 0xf4f4f4f4
            //   c745c0f4f4f4f4       | mov                 dword ptr [ebp - 0x40], 0xf4f4f4f4
            //   c745c4f4f4f4f4       | mov                 dword ptr [ebp - 0x3c], 0xf4f4f4f4

    condition:
        7 of them and filesize < 163840
}