rule win_mikoponi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mikoponi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mikoponi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b07 50 e8???????? 83c404 5e 5b 5d }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp

        $sequence_1 = { 57 e8???????? 2bc7 d1f8 8d742420 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   e8????????           |                     
            //   2bc7                 | sub                 eax, edi
            //   d1f8                 | sar                 eax, 1
            //   8d742420             | lea                 esi, [esp + 0x20]

        $sequence_2 = { e9???????? 68f4010000 56 ff15???????? 8bf8 e8???????? e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   68f4010000           | push                0x1f4
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_3 = { ff15???????? 8b442468 89442414 89442418 33c0 89442430 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b442468             | mov                 eax, dword ptr [esp + 0x68]
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   33c0                 | xor                 eax, eax
            //   89442430             | mov                 dword ptr [esp + 0x30], eax

        $sequence_4 = { b9???????? 8d442440 668b10 663b11 751e }
            // n = 5, score = 100
            //   b9????????           |                     
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   668b10               | mov                 dx, word ptr [eax]
            //   663b11               | cmp                 dx, word ptr [ecx]
            //   751e                 | jne                 0x20

        $sequence_5 = { e8???????? 83c408 8d4c2414 51 57 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   57                   | push                edi

        $sequence_6 = { 81c470040000 c3 68???????? 68???????? ff15???????? 50 ff15???????? }
            // n = 7, score = 100
            //   81c470040000         | add                 esp, 0x470
            //   c3                   | ret                 
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_7 = { e8???????? 68???????? e8???????? 68???????? e8???????? 8b7c2420 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   8b7c2420             | mov                 edi, dword ptr [esp + 0x20]
            //   57                   | push                edi

    condition:
        7 of them and filesize < 330752
}