rule win_mim221_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mim221."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mim221"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d0d77ec0100 e8???????? 488bf0 483bc5 7507 33c0 e9???????? }
            // n = 7, score = 100
            //   488d0d77ec0100       | bt                  ecx, 0x1c
            //   e8????????           |                     
            //   488bf0               | jb                  0xa56
            //   483bc5               | dec                 eax
            //   7507                 | mov                 eax, dword ptr [ebp]
            //   33c0                 | dec                 eax
            //   e9????????           |                     

        $sequence_1 = { 66c785cc0000007800 66c785ce0000006300 66c785d00000006500 66c785d20000007000 66c785d40000007400 66c785d60000006900 66c785d80000006f00 }
            // n = 7, score = 100
            //   66c785cc0000007800     | mov    dword ptr [eax - 0x18], 0
            //   66c785ce0000006300     | mov    word ptr [eax - 0x28], 0
            //   66c785d00000006500     | dec    ecx
            //   66c785d20000007000     | mov    ecx, 0xffffffff
            //   66c785d40000007400     | dec    ecx
            //   66c785d60000006900     | mov    ebx, eax
            //   66c785d80000006f00     | dec    esp

        $sequence_2 = { 48894108 488b442440 488b4808 4885c9 740f ff15???????? 488b4c2440 }
            // n = 7, score = 100
            //   48894108             | xor                 edx, edx
            //   488b442440           | inc                 esp
            //   488b4808             | mov                 dword ptr [esp + 0x698], esi
            //   4885c9               | dec                 esp
            //   740f                 | mov                 dword ptr [esp + 0x6a0], esi
            //   ff15????????         |                     
            //   488b4c2440           | inc                 ebp

        $sequence_3 = { 33d2 488d42ff 48f7f1 4883f801 733b 48c78424b800000000000000 488d9424b8000000 }
            // n = 7, score = 100
            //   33d2                 | inc                 esp
            //   488d42ff             | mov                 dword ptr [esp + 0x694], esi
            //   48f7f1               | inc                 esp
            //   4883f801             | mov                 dword ptr [esp + 0x6b0], esi
            //   733b                 | inc                 ebp
            //   48c78424b800000000000000     | lea    esi, [esp + 4]
            //   488d9424b8000000     | mov                 dword ptr [esp + 0x1a0], eax

        $sequence_4 = { 49c743a80f000000 49c743a000000000 c644247800 33c0 488d48ff 488d7c2460 f2ae }
            // n = 7, score = 100
            //   49c743a80f000000     | mov                 eax, dword ptr [edx + 8]
            //   49c743a000000000     | xor                 ebx, edx
            //   c644247800           | xor                 eax, ebx
            //   33c0                 | xor                 ecx, ebx
            //   488d48ff             | ror                 eax, 4
            //   488d7c2460           | dec                 eax
            //   f2ae                 | and                 eax, ebp

        $sequence_5 = { e8???????? 90 488d4c2450 e8???????? 90 488d054c2b0100 4889442450 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | mov                 word ptr [esp + 0xe0], ax
            //   488d4c2450           | inc                 sp
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [esp + 0xe2], esi
            //   488d054c2b0100       | inc                 sp
            //   4889442450           | mov                 dword ptr [esp + 0xe4], ebx

        $sequence_6 = { c78424c0000000d8000000 89ac24c4000000 89b424c8000000 48c78424d000000020010000 89bc24d8000000 48c78424e000000018000000 44899c24e8000000 }
            // n = 7, score = 100
            //   c78424c0000000d8000000     | inc    sp
            //   89ac24c4000000       | mov                 dword ptr [esp + 0x6c], ebp
            //   89b424c8000000       | mov                 word ptr [esp + 0x6e], 0x32
            //   48c78424d000000020010000     | mov    word ptr [esp + 0x62], 0x72
            //   89bc24d8000000       | mov                 word ptr [esp + 0x64], 0x6f
            //   48c78424e000000018000000     | mov    word ptr [esp + 0x66], 0x72
            //   44899c24e8000000     | mov                 word ptr [esp + 0x68], ax

        $sequence_7 = { 4883f8ff 488be8 0f84ae000000 488d9424c0000000 488bc8 c78424c000000038020000 e8???????? }
            // n = 7, score = 100
            //   4883f8ff             | mov                 dword ptr [esp + 0xe8], edi
            //   488be8               | dec                 esp
            //   0f84ae000000         | mov                 dword ptr [esp + 0xf0], edi
            //   488d9424c0000000     | mov                 dword ptr [esp + 0xf8], ebx
            //   488bc8               | mov                 dword ptr [esp + 0xfc], 1
            //   c78424c000000038020000     | mov    dword ptr [esp + 0xd0], 0x33205054
            //   e8????????           |                     

        $sequence_8 = { 6644897c2450 66c74424526400 66c74424545d00 66897c2456 }
            // n = 4, score = 100
            //   6644897c2450         | mov                 dword ptr [esp + 0x270], eax
            //   66c74424526400       | mov                 dword ptr [esp + 0x260], 0x2580
            //   66c74424545d00       | dec                 ebp
            //   66897c2456           | mov                 eax, esp

        $sequence_9 = { 7505 498bd1 eb21 498b5108 41386849 7504 49895008 }
            // n = 7, score = 100
            //   7505                 | lea                 eax, [eax + 0x48]
            //   498bd1               | dec                 ebp
            //   eb21                 | mov                 ebp, eax
            //   498b5108             | dec                 esp
            //   41386849             | mov                 esi, edx
            //   7504                 | lea                 esi, [edi + 0x1b]
            //   49895008             | lea                 ebx, [edi - 9]

    condition:
        7 of them and filesize < 471040
}