rule win_mimic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mimic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mimic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 51 50 ff36 ff15???????? 85c0 0f84a30a0000 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84a30a0000         | je                  0xaa9

        $sequence_1 = { 0fb6c3 8b5f30 330c8508fa5b00 8d0411 8b542420 33d0 8b442410 }
            // n = 7, score = 100
            //   0fb6c3               | movzx               eax, bl
            //   8b5f30               | mov                 ebx, dword ptr [edi + 0x30]
            //   330c8508fa5b00       | xor                 ecx, dword ptr [eax*4 + 0x5bfa08]
            //   8d0411               | lea                 eax, [ecx + edx]
            //   8b542420             | mov                 edx, dword ptr [esp + 0x20]
            //   33d0                 | xor                 edx, eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_2 = { 898554feffff 85c9 7436 8b9534feffff 8bc1 2bd1 81fa00100000 }
            // n = 7, score = 100
            //   898554feffff         | mov                 dword ptr [ebp - 0x1ac], eax
            //   85c9                 | test                ecx, ecx
            //   7436                 | je                  0x38
            //   8b9534feffff         | mov                 edx, dword ptr [ebp - 0x1cc]
            //   8bc1                 | mov                 eax, ecx
            //   2bd1                 | sub                 edx, ecx
            //   81fa00100000         | cmp                 edx, 0x1000

        $sequence_3 = { 83c40c 56 ff15???????? e9???????? 52 51 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   ff15????????         |                     
            //   e9????????           |                     
            //   52                   | push                edx
            //   51                   | push                ecx

        $sequence_4 = { a0???????? 83ec0c 84c0 7404 8be5 5d c3 }
            // n = 7, score = 100
            //   a0????????           |                     
            //   83ec0c               | sub                 esp, 0xc
            //   84c0                 | test                al, al
            //   7404                 | je                  6
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_5 = { ff15???????? 8b460c ff748604 ff15???????? 837e4800 7440 0f1f8000000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   ff748604             | push                dword ptr [esi + eax*4 + 4]
            //   ff15????????         |                     
            //   837e4800             | cmp                 dword ptr [esi + 0x48], 0
            //   7440                 | je                  0x42
            //   0f1f8000000000       | nop                 dword ptr [eax]

        $sequence_6 = { 3d???????? 740d 8bc8 e8???????? 8b0d???????? 8b5104 8b82f4d55e00 }
            // n = 7, score = 100
            //   3d????????           |                     
            //   740d                 | je                  0xf
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8b82f4d55e00         | mov                 eax, dword ptr [edx + 0x5ed5f4]

        $sequence_7 = { 8d85b4f9ffff 50 56 ffd7 85c0 746c 8b8db8f9ffff }
            // n = 7, score = 100
            //   8d85b4f9ffff         | lea                 eax, [ebp - 0x64c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   746c                 | je                  0x6e
            //   8b8db8f9ffff         | mov                 ecx, dword ptr [ebp - 0x648]

        $sequence_8 = { 50 51 8d8de0feffff e8???????? 6a18 68???????? 51 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8de0feffff         | lea                 ecx, [ebp - 0x120]
            //   e8????????           |                     
            //   6a18                 | push                0x18
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_9 = { ff75b8 0f4345a8 50 e8???????? 33c9 0f1000 0f11854cffffff }
            // n = 7, score = 100
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   0f4345a8             | cmovae              eax, dword ptr [ebp - 0x58]
            //   50                   | push                eax
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   0f11854cffffff       | movups              xmmword ptr [ebp - 0xb4], xmm0

    condition:
        7 of them and filesize < 4204544
}