rule win_mimikatz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mimikatz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mimikatz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f8ff 750e ff15???????? c7002a000000 }
            // n = 4, score = 300
            //   83f8ff               | cmp                 eax, -1
            //   750e                 | jne                 0x10
            //   ff15????????         |                     
            //   c7002a000000         | mov                 dword ptr [eax], 0x2a

        $sequence_1 = { f7f1 85d2 7406 2bca }
            // n = 4, score = 300
            //   f7f1                 | div                 ecx
            //   85d2                 | test                edx, edx
            //   7406                 | je                  8
            //   2bca                 | sub                 ecx, edx

        $sequence_2 = { 3c02 7207 e8???????? eb10 }
            // n = 4, score = 200
            //   3c02                 | cmp                 al, 2
            //   7207                 | jb                  9
            //   e8????????           |                     
            //   eb10                 | jmp                 0x12

        $sequence_3 = { eb84 668b442430 eb1d 834608fe }
            // n = 4, score = 200
            //   eb84                 | jmp                 0xffffff86
            //   668b442430           | mov                 ax, word ptr [esp + 0x30]
            //   eb1d                 | jmp                 0x1f
            //   834608fe             | add                 dword ptr [esi + 8], -2

        $sequence_4 = { 83f812 72f1 33c0 c3 }
            // n = 4, score = 200
            //   83f812               | cmp                 eax, 0x12
            //   72f1                 | jb                  0xfffffff3
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 

        $sequence_5 = { e8???????? 83c8ff e9???????? 8d0412 89442438 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   8d0412               | lea                 eax, [edx + edx]
            //   89442438             | mov                 dword ptr [esp + 0x38], eax

        $sequence_6 = { ff15???????? 85c0 0f94c3 85db 7508 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f94c3               | sete                bl
            //   85db                 | test                ebx, ebx
            //   7508                 | jne                 0xa

        $sequence_7 = { 6683f83f 7607 32c0 e9???????? }
            // n = 4, score = 200
            //   6683f83f             | cmp                 ax, 0x3f
            //   7607                 | jbe                 9
            //   32c0                 | xor                 al, al
            //   e9????????           |                     

        $sequence_8 = { c3 81f998000000 7410 81f996000000 7408 }
            // n = 5, score = 200
            //   c3                   | ret                 
            //   81f998000000         | cmp                 ecx, 0x98
            //   7410                 | je                  0x12
            //   81f996000000         | cmp                 ecx, 0x96
            //   7408                 | je                  0xa

        $sequence_9 = { 66894108 33c0 39410c 740b }
            // n = 4, score = 200
            //   66894108             | mov                 word ptr [ecx + 8], ax
            //   33c0                 | xor                 eax, eax
            //   39410c               | cmp                 dword ptr [ecx + 0xc], eax
            //   740b                 | je                  0xd

        $sequence_10 = { ff15???????? bd6f000000 3bc3 7405 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   bd6f000000           | mov                 ebp, 0x6f
            //   3bc3                 | cmp                 eax, ebx
            //   7405                 | je                  7

        $sequence_11 = { e8???????? 8bf0 85c0 7433 8b542478 d1ea 7420 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85c0                 | test                eax, eax
            //   7433                 | je                  0x35
            //   8b542478             | mov                 edx, dword ptr [esp + 0x78]
            //   d1ea                 | shr                 edx, 1
            //   7420                 | je                  0x22

        $sequence_12 = { ff15???????? 3bc7 0f84d4010000 8b542430 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   3bc7                 | cmp                 eax, edi
            //   0f84d4010000         | je                  0x1da
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]

        $sequence_13 = { 2bc1 85c9 7403 83c008 }
            // n = 4, score = 200
            //   2bc1                 | sub                 eax, ecx
            //   85c9                 | test                ecx, ecx
            //   7403                 | je                  5
            //   83c008               | add                 eax, 8

        $sequence_14 = { 83fb04 7cdc 8b5df8 8ad3 02d2 8ac7 c0e804 }
            // n = 7, score = 100
            //   83fb04               | cmp                 ebx, 4
            //   7cdc                 | jl                  0xffffffde
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]
            //   8ad3                 | mov                 dl, bl
            //   02d2                 | add                 dl, dl
            //   8ac7                 | mov                 al, bh
            //   c0e804               | shr                 al, 4

        $sequence_15 = { 83e001 51 894614 c7461ce0164000 c74620f0164000 c7462410174000 }
            // n = 6, score = 100
            //   83e001               | and                 eax, 1
            //   51                   | push                ecx
            //   894614               | mov                 dword ptr [esi + 0x14], eax
            //   c7461ce0164000       | mov                 dword ptr [esi + 0x1c], 0x4016e0
            //   c74620f0164000       | mov                 dword ptr [esi + 0x20], 0x4016f0
            //   c7462410174000       | mov                 dword ptr [esi + 0x24], 0x401710

        $sequence_16 = { 897e14 897e70 c686c800000043 c6864b01000043 c7466878d14600 6a0d }
            // n = 6, score = 100
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466878d14600       | mov                 dword ptr [esi + 0x68], 0x46d178
            //   6a0d                 | push                0xd

        $sequence_17 = { c745fc00000000 ff15???????? 50 e8???????? 8bd8 }
            // n = 5, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_18 = { 03c2 c1f802 57 50 33db 33f6 e8???????? }
            // n = 7, score = 100
            //   03c2                 | add                 eax, edx
            //   c1f802               | sar                 eax, 2
            //   57                   | push                edi
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   33f6                 | xor                 esi, esi
            //   e8????????           |                     

        $sequence_19 = { 6a00 50 e8???????? 83c40c c7450800000000 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c7450800000000       | mov                 dword ptr [ebp + 8], 0

        $sequence_20 = { 83f805 7d10 668b4c4310 66890c45b8e14600 40 }
            // n = 5, score = 100
            //   83f805               | cmp                 eax, 5
            //   7d10                 | jge                 0x12
            //   668b4c4310           | mov                 cx, word ptr [ebx + eax*2 + 0x10]
            //   66890c45b8e14600     | mov                 word ptr [eax*2 + 0x46e1b8], cx
            //   40                   | inc                 eax

        $sequence_21 = { c705????????cf2f4000 8935???????? a3???????? ff15???????? a3???????? 83f8ff }
            // n = 6, score = 100
            //   c705????????cf2f4000     |     
            //   8935????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   83f8ff               | cmp                 eax, -1

    condition:
        7 of them and filesize < 1642496
}