rule win_mindware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mindware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mindware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 83c40c 8b4dfc 8b7dfc 83c72c }
            // n = 6, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   83c72c               | add                 edi, 0x2c

        $sequence_1 = { 50 8b4d08 8b5108 8b4508 8b12 8b4808 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]

        $sequence_2 = { c7855cecfffff8d44300 c78560ecffff00d54300 c78564ecffff0cd54300 c78568ecffff18d54300 c7856cecffff24d54300 c78570ecffff2cd54300 c78574ecffff34d54300 }
            // n = 7, score = 100
            //   c7855cecfffff8d44300     | mov    dword ptr [ebp - 0x13a4], 0x43d4f8
            //   c78560ecffff00d54300     | mov    dword ptr [ebp - 0x13a0], 0x43d500
            //   c78564ecffff0cd54300     | mov    dword ptr [ebp - 0x139c], 0x43d50c
            //   c78568ecffff18d54300     | mov    dword ptr [ebp - 0x1398], 0x43d518
            //   c7856cecffff24d54300     | mov    dword ptr [ebp - 0x1394], 0x43d524
            //   c78570ecffff2cd54300     | mov    dword ptr [ebp - 0x1390], 0x43d52c
            //   c78574ecffff34d54300     | mov    dword ptr [ebp - 0x138c], 0x43d534

        $sequence_3 = { c1e810 83e03f c1e918 83e13f 8b0c8d603a4400 330c8520394400 8bc2 }
            // n = 7, score = 100
            //   c1e810               | shr                 eax, 0x10
            //   83e03f               | and                 eax, 0x3f
            //   c1e918               | shr                 ecx, 0x18
            //   83e13f               | and                 ecx, 0x3f
            //   8b0c8d603a4400       | mov                 ecx, dword ptr [ecx*4 + 0x443a60]
            //   330c8520394400       | xor                 ecx, dword ptr [eax*4 + 0x443920]
            //   8bc2                 | mov                 eax, edx

        $sequence_4 = { 33148dc0bc4400 8bcb c1e918 33148dc0c44400 8b4df0 }
            // n = 5, score = 100
            //   33148dc0bc4400       | xor                 edx, dword ptr [ecx*4 + 0x44bcc0]
            //   8bcb                 | mov                 ecx, ebx
            //   c1e918               | shr                 ecx, 0x18
            //   33148dc0c44400       | xor                 edx, dword ptr [ecx*4 + 0x44c4c0]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_5 = { e8???????? 8b4dfc 51 e8???????? 8b55fc c7423000000000 8b45fc }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   c7423000000000       | mov                 dword ptr [edx + 0x30], 0
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { c78540f1ffffbce04300 c78544f1ffffc4e04300 c78548f1ffffcce04300 c7854cf1ffffd4e04300 c78550f1ffffe0e04300 c78554f1ffffece04300 c78558f1fffff4e04300 }
            // n = 7, score = 100
            //   c78540f1ffffbce04300     | mov    dword ptr [ebp - 0xec0], 0x43e0bc
            //   c78544f1ffffc4e04300     | mov    dword ptr [ebp - 0xebc], 0x43e0c4
            //   c78548f1ffffcce04300     | mov    dword ptr [ebp - 0xeb8], 0x43e0cc
            //   c7854cf1ffffd4e04300     | mov    dword ptr [ebp - 0xeb4], 0x43e0d4
            //   c78550f1ffffe0e04300     | mov    dword ptr [ebp - 0xeb0], 0x43e0e0
            //   c78554f1ffffece04300     | mov    dword ptr [ebp - 0xeac], 0x43e0ec
            //   c78558f1fffff4e04300     | mov    dword ptr [ebp - 0xea8], 0x43e0f4

        $sequence_7 = { 83e03f 330c8520384400 330c95e03c4400 8bd3 33f1 c1ca04 33576c }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   330c8520384400       | xor                 ecx, dword ptr [eax*4 + 0x443820]
            //   330c95e03c4400       | xor                 ecx, dword ptr [edx*4 + 0x443ce0]
            //   8bd3                 | mov                 edx, ebx
            //   33f1                 | xor                 esi, ecx
            //   c1ca04               | ror                 edx, 4
            //   33576c               | xor                 edx, dword ptr [edi + 0x6c]

        $sequence_8 = { 8b4dfc 8b7dfc 83c72c 32c0 8b4928 }
            // n = 5, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   83c72c               | add                 edi, 0x2c
            //   32c0                 | xor                 al, al
            //   8b4928               | mov                 ecx, dword ptr [ecx + 0x28]

        $sequence_9 = { 0fb689f0d84400 c1e108 33d1 8b4df0 c1e908 0fb6c9 c1e208 }
            // n = 7, score = 100
            //   0fb689f0d84400       | movzx               ecx, byte ptr [ecx + 0x44d8f0]
            //   c1e108               | shl                 ecx, 8
            //   33d1                 | xor                 edx, ecx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   c1e908               | shr                 ecx, 8
            //   0fb6c9               | movzx               ecx, cl
            //   c1e208               | shl                 edx, 8

    condition:
        7 of them and filesize < 661504
}