rule win_miniblindingcan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.miniblindingcan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miniblindingcan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 81fbba470000 7513 488d0511350000 488905???????? e9???????? 81fb63450000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   81fbba470000         | lea                 edx, [esp + 0x20]
            //   7513                 | dec                 ecx
            //   488d0511350000       | mov                 ecx, edi
            //   488905????????       |                     
            //   e9????????           |                     
            //   81fb63450000         | dec                 eax

        $sequence_1 = { 488bc6 488d1523dd0100 83e11f 48c1f805 486bc958 48030cc2 eb07 }
            // n = 7, score = 100
            //   488bc6               | mov                 ecx, ebx
            //   488d1523dd0100       | test                eax, eax
            //   83e11f               | je                  0x1445
            //   48c1f805             | dec                 esp
            //   486bc958             | mov                 eax, edi
            //   48030cc2             | dec                 eax
            //   eb07                 | mov                 ecx, ebx

        $sequence_2 = { 48893d???????? eb1b 488b0d???????? 488d15bf980100 ff15???????? 488905???????? 4183fc0a }
            // n = 7, score = 100
            //   48893d????????       |                     
            //   eb1b                 | lea                 eax, [0x4992]
            //   488b0d????????       |                     
            //   488d15bf980100       | inc                 ecx
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4183fc0a             | cmp                 esp, 6

        $sequence_3 = { 7478 488b03 83e20f 488907 488b4308 4803de 48894708 }
            // n = 7, score = 100
            //   7478                 | cmp                 eax, 0xc
            //   488b03               | je                  0xc62
            //   83e20f               | cmp                 eax, 0xe
            //   488907               | jne                 0xdaf
            //   488b4308             | dec                 eax
            //   4803de               | lea                 edi, [0x1edd1]
            //   48894708             | inc                 ebp

        $sequence_4 = { 8bc0 41890c86 498b0c24 490fafc8 48c1e934 8bc9 418b048e }
            // n = 7, score = 100
            //   8bc0                 | jne                 0xdfb
            //   41890c86             | inc                 ecx
            //   498b0c24             | cmp                 ebx, edi
            //   490fafc8             | jne                 0xe61
            //   48c1e934             | dec                 eax
            //   8bc9                 | lea                 eax, [0x4960]
            //   418b048e             | cmp                 esi, 2

        $sequence_5 = { 8d4af3 ff15???????? 41be4c000000 498bcf 488bd0 458bc6 488be8 }
            // n = 7, score = 100
            //   8d4af3               | lea                 eax, [0x10a10]
            //   ff15????????         |                     
            //   41be4c000000         | dec                 esp
            //   498bcf               | cmp                 edx, eax
            //   488bd0               | je                  0x16c0
            //   458bc6               | dec                 eax
            //   488be8               | mov                 eax, ebx

        $sequence_6 = { 488b8a50000000 e9???????? 4055 4883ec40 488bea 488d4540 4889442430 }
            // n = 7, score = 100
            //   488b8a50000000       | test                eax, eax
            //   e9????????           |                     
            //   4055                 | je                  0x113a
            //   4883ec40             | dec                 esp
            //   488bea               | mov                 eax, dword ptr [ebp - 0x18]
            //   488d4540             | dec                 eax
            //   4889442430           | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_7 = { b835000000 0f05 c3 4c8bd1 b836000000 0f05 }
            // n = 6, score = 100
            //   b835000000           | jne                 0x209c
            //   0f05                 | dec                 eax
            //   c3                   | add                 ecx, 8
            //   4c8bd1               | dec                 eax
            //   b836000000           | add                 edx, 8
            //   0f05                 | dec                 ecx

        $sequence_8 = { 448bc7 488bce 488bd0 4c8be0 e8???????? 3bc5 7412 }
            // n = 7, score = 100
            //   448bc7               | dec                 ecx
            //   488bce               | mov                 ecx, edi
            //   488bd0               | dec                 ecx
            //   4c8be0               | mov                 edx, esi
            //   e8????????           |                     
            //   3bc5                 | dec                 ecx
            //   7412                 | mov                 ecx, esp

        $sequence_9 = { 488b4c2458 c744244802000000 488d442454 4889442440 }
            // n = 4, score = 100
            //   488b4c2458           | inc                 ebp
            //   c744244802000000     | xor                 eax, dword ptr [esp + eax*4 + 0x21260]
            //   488d442454           | inc                 ebp
            //   4889442440           | xor                 eax, dword ptr [ebp + 0x4c]

    condition:
        7 of them and filesize < 453632
}