rule win_minibrowse_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.minibrowse."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.minibrowse"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b10 488b442440 488b08 49b9fe54fd6de0b04522 4c030d???????? }
            // n = 5, score = 100
            //   488b10               | lea                 eax, [ecx + ecx + 0x54]
            //   488b442440           | inc                 ecx
            //   488b08               | shr                 eax, 1
            //   49b9fe54fd6de0b04522     | inc    esp
            //   4c030d????????       |                     

        $sequence_1 = { eb00 488b45b8 8b10 488d4dd8 e8???????? eb00 488b15???????? }
            // n = 7, score = 100
            //   eb00                 | sub                 al, 0x70
            //   488b45b8             | in                  eax, 0x28
            //   8b10                 | dec                 eax
            //   488d4dd8             | add                 eax, ecx
            //   e8????????           |                     
            //   eb00                 | jmp                 0xcb
            //   488b15????????       |                     

        $sequence_2 = { 48b82faa1e82712b2956 480305???????? 8b08 48b82faa1e82712b2956 480305???????? 8908 48b82faa1e82712b2956 }
            // n = 7, score = 100
            //   48b82faa1e82712b2956     | int3    
            //   480305????????       |                     
            //   8b08                 | test                byte ptr [eax - 0x48], 0x2d
            //   48b82faa1e82712b2956     | sbb    bh, byte ptr [eax - 0x3ccd7e39]
            //   480305????????       |                     
            //   8908                 | add                 eax, 0x8420348
            //   48b82faa1e82712b2956     | dec    eax

        $sequence_3 = { ffd0 4889442430 488b542430 488b4c2438 49b8ae95c15973721312 4c0305???????? 48b80ca985ca9581e688 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   4889442430           | dec                 eax
            //   488b542430           | mov                 dword ptr [esp + 0x28], eax
            //   488b4c2438           | dec                 eax
            //   49b8ae95c15973721312     | mov    eax, dword ptr [esp + 0x38]
            //   4c0305????????       |                     
            //   48b80ca985ca9581e688     | dec    eax

        $sequence_4 = { f7f1 89c1 48b85a5ff63d0a40dfa2 480305???????? 8908 48b85a5ff63d0a40dfa2 480305???????? }
            // n = 7, score = 100
            //   f7f1                 | dec                 eax
            //   89c1                 | mov                 eax, 0x9d630657
            //   48b85a5ff63d0a40dfa2     | fimul    word ptr [edi]
            //   480305????????       |                     
            //   8908                 | mov                 cs, word ptr [edi - 0x77]
            //   48b85a5ff63d0a40dfa2     | or    byte ptr [eax - 0x48], cl
            //   480305????????       |                     

        $sequence_5 = { b903000000 31d2 f7f1 89c1 48b8d4f3e92d0d1244e8 480305???????? }
            // n = 6, score = 100
            //   b903000000           | mov                 eax, 0xfffffffe
            //   31d2                 | sub                 eax, ecx
            //   f7f1                 | and                 eax, 0xe7a915a1
            //   89c1                 | inc                 esp
            //   48b8d4f3e92d0d1244e8     | mov    ecx, eax
            //   480305????????       |                     

        $sequence_6 = { 48894c2438 488b442438 4889442428 488b4c2440 48ba99b0f0dd579ba6c4 480315???????? 48b86641bd6f7fab0f25 }
            // n = 7, score = 100
            //   48894c2438           | mov                 dword ptr [esp + 0x30], eax
            //   488b442438           | dec                 eax
            //   4889442428           | mov                 eax, dword ptr [esp + 0x50]
            //   488b4c2440           | dec                 eax
            //   48ba99b0f0dd579ba6c4     | mov    dword ptr [esp + 0x28], eax
            //   480315????????       |                     
            //   48b86641bd6f7fab0f25     | dec    eax

        $sequence_7 = { e9???????? 488b442438 48c7401000000000 488b442438 48c7401807000000 66c744244e0000 488b4c2438 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b442438           | mov                 dword ptr [esp + 0x18], ecx
            //   48c7401000000000     | dec                 eax
            //   488b442438           | add                 edx, 0x14
            //   48c7401807000000     | dec                 eax
            //   66c744244e0000       | mov                 dword ptr [esp + 0x20], edx
            //   488b4c2438           | dec                 eax

        $sequence_8 = { 01ca 48b9ae6044a06c22125f 48030d???????? 8911 a801 7502 eb36 }
            // n = 7, score = 100
            //   01ca                 | test                al, 1
            //   48b9ae6044a06c22125f     | jne    8
            //   48030d????????       |                     
            //   8911                 | jmp                 0x4d
            //   a801                 | add                 edx, ecx
            //   7502                 | dec                 eax
            //   eb36                 | mov                 ecx, 0x850872a6

        $sequence_9 = { 4883ec48 88542447 4c89442438 48894c2430 488b4c2430 48894c2428 48ba856a0e13b3e6f301 }
            // n = 7, score = 100
            //   4883ec48             | sub                 al, 0x48
            //   88542447             | sub                 esp, 0x38
            //   4c89442438           | dec                 eax
            //   48894c2430           | mov                 dword ptr [esp + 0x30], edx
            //   488b4c2430           | dec                 eax
            //   48894c2428           | mov                 dword ptr [esp + 0x28], ecx
            //   48ba856a0e13b3e6f301     | dec    eax

    condition:
        7 of them and filesize < 1779712
}