rule win_minibus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.minibus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.minibus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7cc3 eb25 85db 7421 83ceff 8bc6 }
            // n = 6, score = 300
            //   7cc3                 | jl                  0xffffffc5
            //   eb25                 | jmp                 0x27
            //   85db                 | test                ebx, ebx
            //   7421                 | je                  0x23
            //   83ceff               | or                  esi, 0xffffffff
            //   8bc6                 | mov                 eax, esi

        $sequence_1 = { 0fb742fe 83f85c 7438 83f82f 7433 8b4de4 }
            // n = 6, score = 300
            //   0fb742fe             | movzx               eax, word ptr [edx - 2]
            //   83f85c               | cmp                 eax, 0x5c
            //   7438                 | je                  0x3a
            //   83f82f               | cmp                 eax, 0x2f
            //   7433                 | je                  0x35
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_2 = { 50 8d7720 e8???????? 8b9590fdffff 8b8584fdffff }
            // n = 5, score = 300
            //   50                   | push                eax
            //   8d7720               | lea                 esi, [edi + 0x20]
            //   e8????????           |                     
            //   8b9590fdffff         | mov                 edx, dword ptr [ebp - 0x270]
            //   8b8584fdffff         | mov                 eax, dword ptr [ebp - 0x27c]

        $sequence_3 = { e8???????? 8945f8 3bd8 0f841d010000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   3bd8                 | cmp                 ebx, eax
            //   0f841d010000         | je                  0x123

        $sequence_4 = { 8d4701 3dffffff7f 0f87e8000000 03c0 3d00100000 722a }
            // n = 6, score = 300
            //   8d4701               | lea                 eax, [edi + 1]
            //   3dffffff7f           | cmp                 eax, 0x7fffffff
            //   0f87e8000000         | ja                  0xee
            //   03c0                 | add                 eax, eax
            //   3d00100000           | cmp                 eax, 0x1000
            //   722a                 | jb                  0x2c

        $sequence_5 = { 83fa08 7202 8b3e 8d041b 50 ff75f8 }
            // n = 6, score = 300
            //   83fa08               | cmp                 edx, 8
            //   7202                 | jb                  4
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   8d041b               | lea                 eax, [ebx + ebx]
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_6 = { 33ff 33db 897de4 895de8 85f6 7421 }
            // n = 6, score = 300
            //   33ff                 | xor                 edi, edi
            //   33db                 | xor                 ebx, ebx
            //   897de4               | mov                 dword ptr [ebp - 0x1c], edi
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   85f6                 | test                esi, esi
            //   7421                 | je                  0x23

        $sequence_7 = { e8???????? 8b4de8 83c40c 83f908 7234 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   83c40c               | add                 esp, 0xc
            //   83f908               | cmp                 ecx, 8
            //   7234                 | jb                  0x36

        $sequence_8 = { 8bf1 8975b8 8975ac c745b000000000 c7461000000000 c7461400000000 c70600000000 }
            // n = 7, score = 300
            //   8bf1                 | mov                 esi, ecx
            //   8975b8               | mov                 dword ptr [ebp - 0x48], esi
            //   8975ac               | mov                 dword ptr [ebp - 0x54], esi
            //   c745b000000000       | mov                 dword ptr [ebp - 0x50], 0
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   c70600000000         | mov                 dword ptr [esi], 0

        $sequence_9 = { 8bd1 57 c70600000000 c74604ffff0000 8b4a1c 8bc1 }
            // n = 6, score = 300
            //   8bd1                 | mov                 edx, ecx
            //   57                   | push                edi
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c74604ffff0000       | mov                 dword ptr [esi + 4], 0xffff
            //   8b4a1c               | mov                 ecx, dword ptr [edx + 0x1c]
            //   8bc1                 | mov                 eax, ecx

    condition:
        7 of them and filesize < 324608
}