rule win_minipocket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.minipocket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.minipocket"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f83b 0f87ba000000 8b7df0 8bc7 }
            // n = 4, score = 100
            //   83f83b               | test                eax, eax
            //   0f87ba000000         | je                  0x103
            //   8b7df0               | mov                 edx, 0x68
            //   8bc7                 | dec                 eax

        $sequence_1 = { 488364242800 4533c9 488364242000 488bc8 458d4110 }
            // n = 5, score = 100
            //   488364242800         | mov                 dword ptr [ebp - 0x28], ebx
            //   4533c9               | dec                 eax
            //   488364242000         | mov                 dword ptr [ebp - 0x30], ebx
            //   488bc8               | dec                 eax
            //   458d4110             | test                eax, eax

        $sequence_2 = { 456bc021 4403c0 ffc7 8bc7 8a0417 84c0 75eb }
            // n = 7, score = 100
            //   456bc021             | mov                 dword ptr [esp + 8], ebx
            //   4403c0               | dec                 eax
            //   ffc7                 | mov                 eax, dword ptr [0x60]
            //   8bc7                 | inc                 esp
            //   8a0417               | mov                 edx, edx
            //   84c0                 | inc                 esp
            //   75eb                 | mov                 ebx, ecx

        $sequence_3 = { 4c8d9c24d0020000 498b5b18 498b7b20 498be3 }
            // n = 4, score = 100
            //   4c8d9c24d0020000     | dec                 eax
            //   498b5b18             | mov                 eax, dword ptr [0x60]
            //   498b7b20             | inc                 esp
            //   498be3               | mov                 edx, edx

        $sequence_4 = { c744245492469e5a ff15???????? 488bd8 4883f8ff 0f8412010000 488364243000 488d542450 }
            // n = 7, score = 100
            //   c744245492469e5a     | mov                 ecx, 0x202
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   4883f8ff             | lea                 edx, [ebp + 0x30]
            //   0f8412010000         | test                eax, eax
            //   488364243000         | jne                 0x60c
            //   488d542450           | and                 dword ptr [esp + 0x28], eax

        $sequence_5 = { 410fb70449 6685c0 75ea 413bd3 7419 413bd2 }
            // n = 6, score = 100
            //   410fb70449           | dec                 eax
            //   6685c0               | mov                 dword ptr [ebp - 0x20], ebx
            //   75ea                 | dec                 eax
            //   413bd3               | mov                 dword ptr [ebp - 0x28], ebx
            //   7419                 | dec                 eax
            //   413bd2               | mov                 dword ptr [ebp - 0x30], ebx

        $sequence_6 = { eb11 0fbec0 456bc021 4403c0 ffc7 8bc7 }
            // n = 6, score = 100
            //   eb11                 | dec                 ecx
            //   0fbec0               | add                 edx, ecx
            //   456bc021             | xor                 edi, edi
            //   4403c0               | mov                 al, byte ptr [edx]
            //   ffc7                 | jmp                 0x11e
            //   8bc7                 | inc                 ecx

        $sequence_7 = { 498b4010 4c8b00 eb30 410fb701 }
            // n = 4, score = 100
            //   498b4010             | cmp                 eax, -1
            //   4c8b00               | je                  0x137
            //   eb30                 | dec                 eax
            //   410fb701             | and                 dword ptr [esp + 0x30], 0

        $sequence_8 = { 443bc5 7421 ffc1 4983c204 3bce 72ca 33c0 }
            // n = 7, score = 100
            //   443bc5               | and                 dword ptr [esp + 0x28], 0
            //   7421                 | mov                 dword ptr [esp + 0x20], 1
            //   ffc1                 | call                edi
            //   4983c204             | dec                 eax
            //   3bce                 | mov                 ecx, ebx
            //   72ca                 | dec                 eax
            //   33c0                 | and                 dword ptr [esp + 0x38], 0

        $sequence_9 = { 7474 ba68000000 488d4d80 e8???????? ba18000000 c7458068000000 488d4c2460 }
            // n = 7, score = 100
            //   7474                 | dec                 ebp
            //   ba68000000           | mov                 eax, dword ptr [eax]
            //   488d4d80             | dec                 ebp
            //   e8????????           |                     
            //   ba18000000           | mov                 ecx, dword ptr [eax + 0x60]
            //   c7458068000000       | dec                 ebp
            //   488d4c2460           | test                ecx, ecx

    condition:
        7 of them and filesize < 34816
}