rule win_minitypeframe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.minitypeframe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.minitypeframe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6a0c 6a05 f3a4 e8???????? 8b8dd8000000 8d442430 }
            // n = 7, score = 100
            //   68????????           |                     
            //   6a0c                 | push                0xc
            //   6a05                 | push                5
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   e8????????           |                     
            //   8b8dd8000000         | mov                 ecx, dword ptr [ebp + 0xd8]
            //   8d442430             | lea                 eax, [esp + 0x30]

        $sequence_1 = { 83c414 85c0 750a 68bf080000 e9???????? 8b563c 8b7a04 }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   68bf080000           | push                0x8bf
            //   e9????????           |                     
            //   8b563c               | mov                 edx, dword ptr [esi + 0x3c]
            //   8b7a04               | mov                 edi, dword ptr [edx + 4]

        $sequence_2 = { 8b4c2444 8039a6 0f8504010000 894c2464 8d4c2420 50 8d542420 }
            // n = 7, score = 100
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]
            //   8039a6               | cmp                 byte ptr [ecx], 0xa6
            //   0f8504010000         | jne                 0x10a
            //   894c2464             | mov                 dword ptr [esp + 0x64], ecx
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   50                   | push                eax
            //   8d542420             | lea                 edx, [esp + 0x20]

        $sequence_3 = { 8b1c9d78060910 81e300ff0000 33fb 8bda c1eb18 8b1c9d780e0910 81e3000000ff }
            // n = 7, score = 100
            //   8b1c9d78060910       | mov                 ebx, dword ptr [ebx*4 + 0x10090678]
            //   81e300ff0000         | and                 ebx, 0xff00
            //   33fb                 | xor                 edi, ebx
            //   8bda                 | mov                 ebx, edx
            //   c1eb18               | shr                 ebx, 0x18
            //   8b1c9d780e0910       | mov                 ebx, dword ptr [ebx*4 + 0x10090e78]
            //   81e3000000ff         | and                 ebx, 0xff000000

        $sequence_4 = { e8???????? 83c40c 85c0 751a 6a4b 68???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   6a4b                 | push                0x4b
            //   68????????           |                     

        $sequence_5 = { 83c408 e9???????? 668b15???????? 66c744245c0200 52 ff15???????? 8d4c245c }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   668b15????????       |                     
            //   66c744245c0200       | mov                 word ptr [esp + 0x5c], 2
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d4c245c             | lea                 ecx, [esp + 0x5c]

        $sequence_6 = { c644240416 884c2405 c6442406ba c644240708 c644240898 c644240958 c644240ac1 }
            // n = 7, score = 100
            //   c644240416           | mov                 byte ptr [esp + 4], 0x16
            //   884c2405             | mov                 byte ptr [esp + 5], cl
            //   c6442406ba           | mov                 byte ptr [esp + 6], 0xba
            //   c644240708           | mov                 byte ptr [esp + 7], 8
            //   c644240898           | mov                 byte ptr [esp + 8], 0x98
            //   c644240958           | mov                 byte ptr [esp + 9], 0x58
            //   c644240ac1           | mov                 byte ptr [esp + 0xa], 0xc1

        $sequence_7 = { 51 52 e8???????? 8d442414 6a08 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   6a08                 | push                8

        $sequence_8 = { 6854050000 68???????? 6a44 689b000000 6a14 e8???????? 83c418 }
            // n = 7, score = 100
            //   6854050000           | push                0x554
            //   68????????           |                     
            //   6a44                 | push                0x44
            //   689b000000           | push                0x9b
            //   6a14                 | push                0x14
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_9 = { e8???????? 8bf8 83c404 3bfb 0f8e07020000 c74634d0210000 895e44 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4
            //   3bfb                 | cmp                 edi, ebx
            //   0f8e07020000         | jle                 0x20d
            //   c74634d0210000       | mov                 dword ptr [esi + 0x34], 0x21d0
            //   895e44               | mov                 dword ptr [esi + 0x44], ebx

    condition:
        7 of them and filesize < 1589248
}