rule win_mirage_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mirage."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mirage"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6801000080 ff15???????? 85c0 7556 }
            // n = 5, score = 200
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7556                 | jne                 0x58

        $sequence_1 = { 68???????? c745f804010000 ff75fc ff15???????? ff75fc }
            // n = 5, score = 200
            //   68????????           |                     
            //   c745f804010000       | mov                 dword ptr [ebp - 8], 0x104
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_2 = { 0f84d1000000 57 e8???????? 8d7c0302 c70424???????? }
            // n = 5, score = 200
            //   0f84d1000000         | je                  0xd7
            //   57                   | push                edi
            //   e8????????           |                     
            //   8d7c0302             | lea                 edi, [ebx + eax + 2]
            //   c70424????????       |                     

        $sequence_3 = { 55 8bec b82c410000 e8???????? 53 56 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b82c410000           | mov                 eax, 0x412c
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_4 = { 8d45f4 50 53 68???????? c745f804010000 }
            // n = 5, score = 200
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   68????????           |                     
            //   c745f804010000       | mov                 dword ptr [ebp - 8], 0x104

        $sequence_5 = { e8???????? b8???????? 8d8d90feffff 50 8945e8 e8???????? 3bc3 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   b8????????           |                     
            //   8d8d90feffff         | lea                 ecx, [ebp - 0x170]
            //   50                   | push                eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   e8????????           |                     
            //   3bc3                 | cmp                 eax, ebx

        $sequence_6 = { 0f86a0000000 bf14410000 8d8568bbffff 57 53 }
            // n = 5, score = 200
            //   0f86a0000000         | jbe                 0xa6
            //   bf14410000           | mov                 edi, 0x4114
            //   8d8568bbffff         | lea                 eax, [ebp - 0x4498]
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_7 = { 3bf3 0f85a9000000 381f 0f84a1000000 8d85ecfeffff 68???????? 50 }
            // n = 7, score = 200
            //   3bf3                 | cmp                 esi, ebx
            //   0f85a9000000         | jne                 0xaf
            //   381f                 | cmp                 byte ptr [edi], bl
            //   0f84a1000000         | je                  0xa7
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_8 = { 6a01 6a06 c645ff01 ff7620 }
            // n = 4, score = 200
            //   6a01                 | push                1
            //   6a06                 | push                6
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   ff7620               | push                dword ptr [esi + 0x20]

        $sequence_9 = { 80c261 88543724 46 83fe1f 7ce8 80643e2400 }
            // n = 6, score = 200
            //   80c261               | add                 dl, 0x61
            //   88543724             | mov                 byte ptr [edi + esi + 0x24], dl
            //   46                   | inc                 esi
            //   83fe1f               | cmp                 esi, 0x1f
            //   7ce8                 | jl                  0xffffffea
            //   80643e2400           | and                 byte ptr [esi + edi + 0x24], 0

        $sequence_10 = { e9???????? 83fe04 0f859afdffff 56 8d4508 }
            // n = 5, score = 200
            //   e9????????           |                     
            //   83fe04               | cmp                 esi, 4
            //   0f859afdffff         | jne                 0xfffffda0
            //   56                   | push                esi
            //   8d4508               | lea                 eax, [ebp + 8]

        $sequence_11 = { 66218514fbffff b981000000 8dbd16fbffff c745ec01000000 f3ab 66ab 8d45f4 }
            // n = 7, score = 100
            //   66218514fbffff       | and                 word ptr [ebp - 0x4ec], ax
            //   b981000000           | mov                 ecx, 0x81
            //   8dbd16fbffff         | lea                 edi, [ebp - 0x4ea]
            //   c745ec01000000       | mov                 dword ptr [ebp - 0x14], 1
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_12 = { e8???????? 83c410 56 8d8514fbffff 6a00 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   56                   | push                esi
            //   8d8514fbffff         | lea                 eax, [ebp - 0x4ec]
            //   6a00                 | push                0

        $sequence_13 = { ab ab 33c0 8dbda6ebffff 6689b5a4ebffff }
            // n = 5, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   33c0                 | xor                 eax, eax
            //   8dbda6ebffff         | lea                 edi, [ebp - 0x145a]
            //   6689b5a4ebffff       | mov                 word ptr [ebp - 0x145c], si

        $sequence_14 = { c3 53 e8???????? 59 ff75f0 ff15???????? }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     

        $sequence_15 = { ffd7 85c0 7547 8d8514fbffff 85c0 }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7547                 | jne                 0x49
            //   8d8514fbffff         | lea                 eax, [ebp - 0x4ec]
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 1695744
}