rule win_miragefox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.miragefox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miragefox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945ca 8b45f4 83c036 66c745c8424d }
            // n = 4, score = 100
            //   8945ca               | mov                 dword ptr [ebp - 0x36], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c036               | add                 eax, 0x36
            //   66c745c8424d         | mov                 word ptr [ebp - 0x38], 0x4d42

        $sequence_1 = { 8b45e0 8b4df4 53 50 8d440828 50 }
            // n = 6, score = 100
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d440828             | lea                 eax, [eax + ecx + 0x28]
            //   50                   | push                eax

        $sequence_2 = { 8a8010132a00 83e00f eb02 33c0 0fbe84c130132a00 c1f804 }
            // n = 6, score = 100
            //   8a8010132a00         | mov                 al, byte ptr [eax + 0x2a1310]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c130132a00     | movsx               eax, byte ptr [ecx + eax*8 + 0x2a1330]
            //   c1f804               | sar                 eax, 4

        $sequence_3 = { 8d45fc 50 e8???????? 59 8d44180c }
            // n = 5, score = 100
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d44180c             | lea                 eax, [eax + ebx + 0xc]

        $sequence_4 = { 57 8d859c7cffff 6a00 50 e8???????? 57 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   8d859c7cffff         | lea                 eax, [ebp - 0x8364]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_5 = { 2900 59 352900be35 2900 3236 2900 98 }
            // n = 7, score = 100
            //   2900                 | sub                 dword ptr [eax], eax
            //   59                   | pop                 ecx
            //   352900be35           | xor                 eax, 0x35be0029
            //   2900                 | sub                 dword ptr [eax], eax
            //   3236                 | xor                 dh, byte ptr [esi]
            //   2900                 | sub                 dword ptr [eax], eax
            //   98                   | cwde                

        $sequence_6 = { 83c418 8d45ec 53 50 8d857cbcffff }
            // n = 5, score = 100
            //   83c418               | add                 esp, 0x18
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d857cbcffff         | lea                 eax, [ebp - 0x4384]

        $sequence_7 = { 85c0 0f84be000000 8d85c0feffff 50 8d85b8fcffff 68???????? 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84be000000         | je                  0xc4
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   50                   | push                eax
            //   8d85b8fcffff         | lea                 eax, [ebp - 0x348]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_8 = { 83c01f 894d8c 99 59 8b75b8 f7f9 8b4df4 }
            // n = 7, score = 100
            //   83c01f               | add                 eax, 0x1f
            //   894d8c               | mov                 dword ptr [ebp - 0x74], ecx
            //   99                   | cdq                 
            //   59                   | pop                 ecx
            //   8b75b8               | mov                 esi, dword ptr [ebp - 0x48]
            //   f7f9                 | idiv                ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_9 = { 8d45f0 8975ec 50 8d45f8 }
            // n = 4, score = 100
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]

    condition:
        7 of them and filesize < 286720
}