rule win_misha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.misha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.misha"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0d19000200 50 8b4318 0508010000 50 }
            // n = 5, score = 300
            //   0d19000200           | or                  eax, 0x20019
            //   50                   | push                eax
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]
            //   0508010000           | add                 eax, 0x108
            //   50                   | push                eax

        $sequence_1 = { 6a08 59 8bc3 c1e310 0bc3 6a18 8bfa }
            // n = 7, score = 300
            //   6a08                 | push                8
            //   59                   | pop                 ecx
            //   8bc3                 | mov                 eax, ebx
            //   c1e310               | shl                 ebx, 0x10
            //   0bc3                 | or                  eax, ebx
            //   6a18                 | push                0x18
            //   8bfa                 | mov                 edi, edx

        $sequence_2 = { ff75c8 8b4314 83c070 50 8b8578ffffff 48 48 }
            // n = 7, score = 300
            //   ff75c8               | push                dword ptr [ebp - 0x38]
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   83c070               | add                 eax, 0x70
            //   50                   | push                eax
            //   8b8578ffffff         | mov                 eax, dword ptr [ebp - 0x88]
            //   48                   | dec                 eax
            //   48                   | dec                 eax

        $sequence_3 = { 50 8b4314 05d8000000 50 ff75ec 8b7308 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   05d8000000           | add                 eax, 0xd8
            //   50                   | push                eax
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8b7308               | mov                 esi, dword ptr [ebx + 8]

        $sequence_4 = { 50 8b4318 0508020000 50 ff730c e8???????? }
            // n = 6, score = 300
            //   50                   | push                eax
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]
            //   0508020000           | add                 eax, 0x208
            //   50                   | push                eax
            //   ff730c               | push                dword ptr [ebx + 0xc]
            //   e8????????           |                     

        $sequence_5 = { 8945e8 8b4510 8b00 8945e4 8d45fc }
            // n = 5, score = 300
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_6 = { c78550feffff18181818 c78554feffff18181818 c78558feffff18181819 c7855cfeffff19191919 c78560feffff19191919 c78564feffff19191919 c78568feffff19191919 }
            // n = 7, score = 300
            //   c78550feffff18181818     | mov    dword ptr [ebp - 0x1b0], 0x18181818
            //   c78554feffff18181818     | mov    dword ptr [ebp - 0x1ac], 0x18181818
            //   c78558feffff18181819     | mov    dword ptr [ebp - 0x1a8], 0x19181818
            //   c7855cfeffff19191919     | mov    dword ptr [ebp - 0x1a4], 0x19191919
            //   c78560feffff19191919     | mov    dword ptr [ebp - 0x1a0], 0x19191919
            //   c78564feffff19191919     | mov    dword ptr [ebp - 0x19c], 0x19191919
            //   c78568feffff19191919     | mov    dword ptr [ebp - 0x198], 0x19191919

        $sequence_7 = { 6a00 e8???????? 83c40c 8b45f4 8a4d0c 884818 8b45f4 }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8a4d0c               | mov                 cl, byte ptr [ebp + 0xc]
            //   884818               | mov                 byte ptr [eax + 0x18], cl
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_8 = { 8d85f8f9ffff 50 8d85e0f9ffff e8???????? 83c40c 0fb6c0 }
            // n = 6, score = 300
            //   8d85f8f9ffff         | lea                 eax, [ebp - 0x608]
            //   50                   | push                eax
            //   8d85e0f9ffff         | lea                 eax, [ebp - 0x620]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   0fb6c0               | movzx               eax, al

        $sequence_9 = { 8d8568ffffff 50 6a01 6a02 8b4314 83c008 50 }
            // n = 7, score = 300
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   83c008               | add                 eax, 8
            //   50                   | push                eax

    condition:
        7 of them and filesize < 710656
}