rule win_mispadu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mispadu"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd0 8bc3 59 8b18 ff5360 83c430 5d }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8bc3                 | mov                 eax, ebx
            //   59                   | pop                 ecx
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff5360               | call                dword ptr [ebx + 0x60]
            //   83c430               | add                 esp, 0x30
            //   5d                   | pop                 ebp

        $sequence_1 = { 8b951cfbffff 8b45b8 8b80e0030000 8b8098000000 e8???????? 837db001 756f }
            // n = 7, score = 100
            //   8b951cfbffff         | mov                 edx, dword ptr [ebp - 0x4e4]
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   8b80e0030000         | mov                 eax, dword ptr [eax + 0x3e0]
            //   8b8098000000         | mov                 eax, dword ptr [eax + 0x98]
            //   e8????????           |                     
            //   837db001             | cmp                 dword ptr [ebp - 0x50], 1
            //   756f                 | jne                 0x71

        $sequence_2 = { e8???????? 837df800 7412 837df400 740c 837df000 7406 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7412                 | je                  0x14
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   740c                 | je                  0xe
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   7406                 | je                  8

        $sequence_3 = { b205 8b45fc 8b18 ff93d0000000 8d45f0 ba080000ff e8???????? }
            // n = 7, score = 100
            //   b205                 | mov                 dl, 5
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff93d0000000         | call                dword ptr [ebx + 0xd0]
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   ba080000ff           | mov                 edx, 0xff000008
            //   e8????????           |                     

        $sequence_4 = { b201 a1???????? e8???????? 8be8 896f14 897d3c c7453844c87f03 }
            // n = 7, score = 100
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   896f14               | mov                 dword ptr [edi + 0x14], ebp
            //   897d3c               | mov                 dword ptr [ebp + 0x3c], edi
            //   c7453844c87f03       | mov                 dword ptr [ebp + 0x38], 0x37fc844

        $sequence_5 = { 8bc3 e8???????? 8b55fc 8bce 8bc3 e8???????? 80bbcc02000000 }
            // n = 7, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8bce                 | mov                 ecx, esi
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   80bbcc02000000       | cmp                 byte ptr [ebx + 0x2cc], 0

        $sequence_6 = { e8???????? 8d45f8 50 b901000000 8b55f8 b8???????? e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   b901000000           | mov                 ecx, 1
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   b8????????           |                     
            //   e8????????           |                     

        $sequence_7 = { e8???????? 80bb5c09000000 7520 833d????????02 7517 8bc3 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   80bb5c09000000       | cmp                 byte ptr [ebx + 0x95c], 0
            //   7520                 | jne                 0x22
            //   833d????????02       |                     
            //   7517                 | jne                 0x19
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_8 = { e8???????? 8d45e8 50 6aff 6a00 6a00 8d45e8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d45e8               | lea                 eax, [ebp - 0x18]

        $sequence_9 = { 41 51 6a00 6a00 8b451c 50 8b5518 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   50                   | push                eax
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]

    condition:
        7 of them and filesize < 14024704
}