rule win_mistpen_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mistpen."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mistpen"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7602 ffc0 4585c0 8bf0 }
            // n = 4, score = 100
            //   7602                 | lea                 eax, [0x195]
            //   ffc0                 | dec                 eax
            //   4585c0               | lea                 eax, [0x1a09f]
            //   8bf0                 | dec                 ebx

        $sequence_1 = { 420fb6842090960200 4433d8 45335ffc 4533da 458bd3 45895e20 4533d0 }
            // n = 7, score = 100
            //   420fb6842090960200     | mov    eax, esi
            //   4433d8               | inc                 ecx
            //   45335ffc             | inc                 esi
            //   4533da               | cmp                 dword ptr [ebp], 0x4550
            //   458bd3               | jne                 0xba6
            //   45895e20             | mov                 eax, 0x8664
            //   4533d0               | cmp                 word ptr [ebp + 4], ax

        $sequence_2 = { 4533848460850200 410fb6c3 4533848460750200 400fb6c7 4533848490920200 4533465c 418bc0 }
            // n = 7, score = 100
            //   4533848460850200     | lea                 ecx, [0x10325]
            //   410fb6c3             | mov                 eax, ecx
            //   4533848460750200     | shr                 eax, 8
            //   400fb6c7             | mov                 byte ptr [ebp - 0x6a], al
            //   4533848490920200     | mov                 byte ptr [ebp - 0x69], cl
            //   4533465c             | mov                 ecx, dword ptr [esp + 0x54]
            //   418bc0               | mov                 eax, ecx

        $sequence_3 = { 4403c1 418bcb 410bca 458bc8 23cf 41c1c91b }
            // n = 6, score = 100
            //   4403c1               | movzx               ecx, al
            //   418bcb               | inc                 ecx
            //   410bca               | movzx               eax, cl
            //   458bc8               | inc                 ecx
            //   23cf                 | shr                 ecx, 0x10
            //   41c1c91b             | inc                 ecx

        $sequence_4 = { 4c8d0d74d70000 b919000000 4c8d0564d70000 488d1561d70000 e8???????? 4885c0 7420 }
            // n = 7, score = 100
            //   4c8d0d74d70000       | xor                 eax, dword ptr [esp + eax*4 + 0x27d60]
            //   b919000000           | inc                 ecx
            //   4c8d0564d70000       | movzx               eax, bl
            //   488d1561d70000       | inc                 ebp
            //   e8????????           |                     
            //   4885c0               | xor                 eax, dword ptr [esp + eax*4 + 0x28d60]
            //   7420                 | movzx               eax, bl

        $sequence_5 = { c1e31e 8bcf 410bcd 8bc7 4123cf 4123c5 0bc8 }
            // n = 7, score = 100
            //   c1e31e               | inc                 ecx
            //   8bcf                 | xor                 ebp, dword ptr [esp + eax*4 + 0x27960]
            //   410bcd               | inc                 ecx
            //   8bc7                 | movzx               eax, al
            //   4123cf               | inc                 ecx
            //   4123c5               | xor                 ebp, dword ptr [esp + eax*4 + 0x28d60]
            //   0bc8                 | inc                 ecx

        $sequence_6 = { 458b8c9460810200 4133bc8490920200 418bc0 41337e20 c1e808 0fb6c8 8bc3 }
            // n = 7, score = 100
            //   458b8c9460810200     | mov                 edi, edx
            //   4133bc8490920200     | dec                 esp
            //   418bc0               | lea                 ecx, [0xd541]
            //   41337e20             | dec                 eax
            //   c1e808               | mov                 ebx, ecx
            //   0fb6c8               | dec                 eax
            //   8bc3                 | lea                 edx, [0xd537]

        $sequence_7 = { 83f838 7cec 8b4c2458 8bc1 c1e818 884594 8bc1 }
            // n = 7, score = 100
            //   83f838               | dec                 eax
            //   7cec                 | lea                 edx, [0x25375]
            //   8b4c2458             | inc                 ebp
            //   8bc1                 | xor                 eax, eax
            //   c1e818               | dec                 eax
            //   884594               | lea                 ecx, [ebx + ebx*4]
            //   8bc1                 | dec                 eax

        $sequence_8 = { 488d45e8 48894de8 488945f0 488d1590d10000 b805000000 894520 }
            // n = 6, score = 100
            //   488d45e8             | je                  0x1fad
            //   48894de8             | xor                 ecx, ecx
            //   488945f0             | mov                 word ptr [ebp + 8], cx
            //   488d1590d10000       | mov                 byte ptr [ebp + 0xa], cl
            //   b805000000           | movups              xmmword ptr [ebp - 0x58], xmm0
            //   894520               | movups              xmmword ptr [ebp - 0x48], xmm0

        $sequence_9 = { 7e1d 488b5588 4c8d4c2450 458bc4 498bce }
            // n = 5, score = 100
            //   7e1d                 | inc                 ebp
            //   488b5588             | xor                 edx, dword ptr [esp + eax*4 + 0x29290]
            //   4c8d4c2450           | inc                 ebp
            //   458bc4               | xor                 edx, dword ptr [esi + 0x18]
            //   498bce               | inc                 ecx

    condition:
        7 of them and filesize < 458752
}