rule win_miya_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.miya_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miya_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f84fa0f0000 83ec08 0fae5c2404 8b442404 25807f0000 3d801f0000 750f }
            // n = 7, score = 200
            //   0f84fa0f0000         | je                  0x1000
            //   83ec08               | sub                 esp, 8
            //   0fae5c2404           | stmxcsr             dword ptr [esp + 4]
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   25807f0000           | and                 eax, 0x7f80
            //   3d801f0000           | cmp                 eax, 0x1f80
            //   750f                 | jne                 0x11

        $sequence_1 = { 0fbf45fc c9 c3 8bff 55 8bec 83ec18 }
            // n = 7, score = 200
            //   0fbf45fc             | movsx               eax, word ptr [ebp - 4]
            //   c9                   | leave               
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18

        $sequence_2 = { 68a00f0000 ff15???????? 6a00 6a00 6a00 6a06 6a01 }
            // n = 7, score = 200
            //   68a00f0000           | push                0xfa0
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a06                 | push                6
            //   6a01                 | push                1

        $sequence_3 = { 7541 d9ec d9c9 d9f1 833d????????00 0f854c0d0000 }
            // n = 6, score = 200
            //   7541                 | jne                 0x43
            //   d9ec                 | fldlg2              
            //   d9c9                 | fxch                st(1)
            //   d9f1                 | fyl2x               
            //   833d????????00       |                     
            //   0f854c0d0000         | jne                 0xd52

        $sequence_4 = { 5d e9???????? 8bff 55 8bec b8ffff0000 83ec14 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   e9????????           |                     
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b8ffff0000           | mov                 eax, 0xffff
            //   83ec14               | sub                 esp, 0x14

        $sequence_5 = { 8bc6 5e 5d c20400 e8???????? cc 56 }
            // n = 7, score = 200
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   e8????????           |                     
            //   cc                   | int3                
            //   56                   | push                esi

        $sequence_6 = { 8d642408 0f85c90f0000 eb00 f30f7e442404 660f2815???????? 660f28c8 660f28f8 }
            // n = 7, score = 200
            //   8d642408             | lea                 esp, [esp + 8]
            //   0f85c90f0000         | jne                 0xfcf
            //   eb00                 | jmp                 2
            //   f30f7e442404         | movq                xmm0, qword ptr [esp + 4]
            //   660f2815????????     |                     
            //   660f28c8             | movapd              xmm1, xmm0
            //   660f28f8             | movapd              xmm7, xmm0

        $sequence_7 = { 75be ddd8 db2d???????? b802000000 833d????????00 0f85e00c0000 }
            // n = 6, score = 200
            //   75be                 | jne                 0xffffffc0
            //   ddd8                 | fstp                st(0)
            //   db2d????????         |                     
            //   b802000000           | mov                 eax, 2
            //   833d????????00       |                     
            //   0f85e00c0000         | jne                 0xce6

        $sequence_8 = { 4889742418 57 4883ec20 488d05da910700 33f6 488901 488b4108 }
            // n = 7, score = 100
            //   4889742418           | dec                 eax
            //   57                   | mov                 edx, esi
            //   4883ec20             | dec                 eax
            //   488d05da910700       | lea                 ecx, [ebp - 0x39]
            //   33f6                 | dec                 eax
            //   488901               | mov                 edi, dword ptr [ebp - 0x21]
            //   488b4108             | inc                 ebp

        $sequence_9 = { e9???????? 488d8a48000000 e9???????? 488d8a40010000 e9???????? 488d8ab0010000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8a48000000       | xor                 esp, esp
            //   e9????????           |                     
            //   488d8a40010000       | jmp                 0x77
            //   e9????????           |                     
            //   488d8ab0010000       | dec                 eax
            //   e9????????           |                     

        $sequence_10 = { 4c8bc7 89742428 33d2 b9e9fd0000 4889442420 ff15???????? 0f10442450 }
            // n = 7, score = 100
            //   4c8bc7               | dec                 eax
            //   89742428             | lea                 ecx, [ebp + 0x40]
            //   33d2                 | dec                 esp
            //   b9e9fd0000           | mov                 eax, edi
            //   4889442420           | mov                 dword ptr [esp + 0x28], esi
            //   ff15????????         |                     
            //   0f10442450           | xor                 edx, edx

        $sequence_11 = { 4533c0 488bd6 488d4dc7 e8???????? 488b7ddf 4533e4 eb67 }
            // n = 7, score = 100
            //   4533c0               | mov                 ecx, 0xfde9
            //   488bd6               | dec                 eax
            //   488d4dc7             | mov                 dword ptr [esp + 0x20], eax
            //   e8????????           |                     
            //   488b7ddf             | movups              xmm0, xmmword ptr [esp + 0x50]
            //   4533e4               | inc                 ebp
            //   eb67                 | xor                 eax, eax

        $sequence_12 = { 0f57c9 f30f7f4d40 488d4d40 e8???????? 488d4d40 e8???????? }
            // n = 6, score = 100
            //   0f57c9               | xorps               xmm1, xmm1
            //   f30f7f4d40           | movdqu              xmmword ptr [ebp + 0x40], xmm1
            //   488d4d40             | dec                 eax
            //   e8????????           |                     
            //   488d4d40             | lea                 ecx, [ebp + 0x40]
            //   e8????????           |                     

        $sequence_13 = { 0f1145c7 4c8965d7 48897ddf 66448965c7 488d7160 48897597 44386168 }
            // n = 7, score = 100
            //   0f1145c7             | mov                 dword ptr [esp + 0x18], esi
            //   4c8965d7             | push                edi
            //   48897ddf             | dec                 eax
            //   66448965c7           | sub                 esp, 0x20
            //   488d7160             | dec                 eax
            //   48897597             | lea                 eax, [0x791da]
            //   44386168             | xor                 esi, esi

        $sequence_14 = { 0f57c0 488d5308 48890b 488d4808 0f1102 e8???????? 488d0588aa0600 }
            // n = 7, score = 100
            //   0f57c0               | dec                 eax
            //   488d5308             | lea                 ecx, [edx + 0x140]
            //   48890b               | dec                 eax
            //   488d4808             | lea                 ecx, [edx + 0x1b0]
            //   0f1102               | movups              xmmword ptr [ebp - 0x39], xmm0
            //   e8????????           |                     
            //   488d0588aa0600       | dec                 esp

        $sequence_15 = { 90 44897608 488d0554590500 488906 488937 488d4dd7 e8???????? }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   44897608             | mov                 dword ptr [ecx], eax
            //   488d0554590500       | dec                 eax
            //   488906               | mov                 eax, dword ptr [ecx + 8]
            //   488937               | dec                 eax
            //   488d4dd7             | lea                 ecx, [edx + 0x48]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1238016
}