rule win_mm_core_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mm_core."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mm_core"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ff 8db7e8ba0010 ff36 e8???????? 83c704 }
            // n = 5, score = 200
            //   33ff                 | xor                 edi, edi
            //   8db7e8ba0010         | lea                 esi, [edi + 0x1000bae8]
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     
            //   83c704               | add                 edi, 4

        $sequence_1 = { ff15???????? 85c0 0f8482000000 8b442410 3bc7 747a 40 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8482000000         | je                  0x88
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   3bc7                 | cmp                 eax, edi
            //   747a                 | je                  0x7c
            //   40                   | inc                 eax

        $sequence_2 = { 6800000008 51 51 51 66894c2464 8bcb }
            // n = 6, score = 200
            //   6800000008           | push                0x8000000
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   66894c2464           | mov                 word ptr [esp + 0x64], cx
            //   8bcb                 | mov                 ecx, ebx

        $sequence_3 = { 8bf0 8975d4 85f6 0f8485000000 c745fc00000000 8a0e }
            // n = 6, score = 200
            //   8bf0                 | mov                 esi, eax
            //   8975d4               | mov                 dword ptr [ebp - 0x2c], esi
            //   85f6                 | test                esi, esi
            //   0f8485000000         | je                  0x8b
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8a0e                 | mov                 cl, byte ptr [esi]

        $sequence_4 = { 8b84246c080000 56 57 33ff 6a3c 8bf2 }
            // n = 6, score = 200
            //   8b84246c080000       | mov                 eax, dword ptr [esp + 0x86c]
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   6a3c                 | push                0x3c
            //   8bf2                 | mov                 esi, edx

        $sequence_5 = { 6a00 50 e8???????? 83c40c 33c0 33c9 8d542408 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   33c9                 | xor                 ecx, ecx
            //   8d542408             | lea                 edx, [esp + 8]

        $sequence_6 = { 3bc1 0f87f5090000 ff248516540010 33c0 }
            // n = 4, score = 200
            //   3bc1                 | cmp                 eax, ecx
            //   0f87f5090000         | ja                  0x9fb
            //   ff248516540010       | jmp                 dword ptr [eax*4 + 0x10005416]
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 33c0 eb1a 8bc8 83e01f c1f905 8b0c8d40400110 c1e006 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   eb1a                 | jmp                 0x1c
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d40400110       | mov                 ecx, dword ptr [ecx*4 + 0x10014040]
            //   c1e006               | shl                 eax, 6

        $sequence_8 = { 83e71f c1e706 8b048540400110 8d44380c }
            // n = 4, score = 200
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6
            //   8b048540400110       | mov                 eax, dword ptr [eax*4 + 0x10014040]
            //   8d44380c             | lea                 eax, [eax + edi + 0xc]

        $sequence_9 = { c744240c01010000 ff15???????? 8d4c2418 51 8d54240c }
            // n = 5, score = 200
            //   c744240c01010000     | mov                 dword ptr [esp + 0xc], 0x101
            //   ff15????????         |                     
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx
            //   8d54240c             | lea                 edx, [esp + 0xc]

    condition:
        7 of them and filesize < 319488
}