rule win_moker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0302 8945d4 8b4dd4 83c102 }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   83c102               | add                 ecx, 2

        $sequence_1 = { 0301 8945e0 e8???????? 8b55e8 }
            // n = 4, score = 200
            //   0301                 | add                 eax, dword ptr [ecx]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   e8????????           |                     
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_2 = { 0100 83c414 85c0 7502 eb0a }
            // n = 5, score = 200
            //   0100                 | add                 dword ptr [eax], eax
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb0a                 | jmp                 0xc

        $sequence_3 = { 0302 8945e8 eb09 8b45e8 }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   eb09                 | jmp                 0xb
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_4 = { 0302 8945dc 8b45dc 83c002 }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   83c002               | add                 eax, 2

        $sequence_5 = { 0302 8945e8 8b4df8 8b55fc }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_6 = { 6a00 8b15???????? 52 6a1e 6a3c }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   8b15????????         |                     
            //   52                   | push                edx
            //   6a1e                 | push                0x1e
            //   6a3c                 | push                0x3c

        $sequence_7 = { 0302 50 e8???????? 83c404 3b450c 750b 8b4df0 }
            // n = 7, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]
            //   750b                 | jne                 0xd
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_8 = { 034508 8078fe5c 740d c6005c c6400100 }
            // n = 5, score = 100
            //   034508               | add                 eax, dword ptr [ebp + 8]
            //   8078fe5c             | cmp                 byte ptr [eax - 2], 0x5c
            //   740d                 | je                  0xf
            //   c6005c               | mov                 byte ptr [eax], 0x5c
            //   c6400100             | mov                 byte ptr [eax + 1], 0

        $sequence_9 = { 50 6800800000 6a00 ff7508 ff15???????? e8???????? 9d }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6800800000           | push                0x8000
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   e8????????           |                     
            //   9d                   | popfd               

        $sequence_10 = { 39f7 7410 fc 39fe }
            // n = 4, score = 100
            //   39f7                 | cmp                 edi, esi
            //   7410                 | je                  0x12
            //   fc                   | cld                 
            //   39fe                 | cmp                 esi, edi

        $sequence_11 = { 730c 8b420c 29c6 8b4214 01c6 eb06 83c228 }
            // n = 7, score = 100
            //   730c                 | jae                 0xe
            //   8b420c               | mov                 eax, dword ptr [edx + 0xc]
            //   29c6                 | sub                 esi, eax
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   01c6                 | add                 esi, eax
            //   eb06                 | jmp                 8
            //   83c228               | add                 edx, 0x28

        $sequence_12 = { eb82 8b86b8000000 40 8d5002 83aec400000004 }
            // n = 5, score = 100
            //   eb82                 | jmp                 0xffffff84
            //   8b86b8000000         | mov                 eax, dword ptr [esi + 0xb8]
            //   40                   | inc                 eax
            //   8d5002               | lea                 edx, [eax + 2]
            //   83aec400000004       | sub                 dword ptr [esi + 0xc4], 4

        $sequence_13 = { 75eb 59 5e 5f c9 c21000 }
            // n = 6, score = 100
            //   75eb                 | jne                 0xffffffed
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c21000               | ret                 0x10

        $sequence_14 = { 51 8b4510 48 ff4514 }
            // n = 4, score = 100
            //   51                   | push                ecx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   48                   | dec                 eax
            //   ff4514               | inc                 dword ptr [ebp + 0x14]

        $sequence_15 = { 8d5001 52 8d5580 52 e42b }
            // n = 5, score = 100
            //   8d5001               | lea                 edx, [eax + 1]
            //   52                   | push                edx
            //   8d5580               | lea                 edx, [ebp - 0x80]
            //   52                   | push                edx
            //   e42b                 | in                  al, 0x2b

    condition:
        7 of them and filesize < 1761280
}