rule win_monero_miner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.monero_miner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.monero_miner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6043000 c744240811000000 89442404 c70424???????? e8???????? 85c0 7411 }
            // n = 7, score = 100
            //   c6043000             | mov                 byte ptr [eax + esi], 0
            //   c744240811000000     | mov                 dword ptr [esp + 8], 0x11
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c70424????????       |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13

        $sequence_1 = { e8???????? 0fb643fa 8d4e04 c7442404???????? 890c24 89442408 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb643fa             | movzx               eax, byte ptr [ebx - 6]
            //   8d4e04               | lea                 ecx, [esi + 4]
            //   c7442404????????     |                     
            //   890c24               | mov                 dword ptr [esp], ecx
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   e8????????           |                     

        $sequence_2 = { 8b6c240c 136c2424 8b8c24d4000000 8bbc24dc000000 89c2 8b4350 31f2 }
            // n = 7, score = 100
            //   8b6c240c             | mov                 ebp, dword ptr [esp + 0xc]
            //   136c2424             | adc                 ebp, dword ptr [esp + 0x24]
            //   8b8c24d4000000       | mov                 ecx, dword ptr [esp + 0xd4]
            //   8bbc24dc000000       | mov                 edi, dword ptr [esp + 0xdc]
            //   89c2                 | mov                 edx, eax
            //   8b4350               | mov                 eax, dword ptr [ebx + 0x50]
            //   31f2                 | xor                 edx, esi

        $sequence_3 = { e8???????? 8d9424a0000000 8d442460 b901000000 e8???????? 8d542460 8d8424a0000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d9424a0000000       | lea                 edx, [esp + 0xa0]
            //   8d442460             | lea                 eax, [esp + 0x60]
            //   b901000000           | mov                 ecx, 1
            //   e8????????           |                     
            //   8d542460             | lea                 edx, [esp + 0x60]
            //   8d8424a0000000       | lea                 eax, [esp + 0xa0]

        $sequence_4 = { 890424 e8???????? 83f8ff 0f8463050000 817c2434ff3f0000 8b442430 0f96c2 }
            // n = 7, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f8463050000         | je                  0x569
            //   817c2434ff3f0000     | cmp                 dword ptr [esp + 0x34], 0x3fff
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   0f96c2               | setbe               dl

        $sequence_5 = { 8b94247c010000 898c2448020000 899c244c020000 8b9c248c010000 89c5 0fa4d017 0fa4ea17 }
            // n = 7, score = 100
            //   8b94247c010000       | mov                 edx, dword ptr [esp + 0x17c]
            //   898c2448020000       | mov                 dword ptr [esp + 0x248], ecx
            //   899c244c020000       | mov                 dword ptr [esp + 0x24c], ebx
            //   8b9c248c010000       | mov                 ebx, dword ptr [esp + 0x18c]
            //   89c5                 | mov                 ebp, eax
            //   0fa4d017             | shld                eax, edx, 0x17
            //   0fa4ea17             | shld                edx, ebp, 0x17

        $sequence_6 = { 8db4248c000000 c60000 89442414 8b8398000000 8974240c c7442404???????? 89442410 }
            // n = 7, score = 100
            //   8db4248c000000       | lea                 esi, [esp + 0x8c]
            //   c60000               | mov                 byte ptr [eax], 0
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8b8398000000         | mov                 eax, dword ptr [ebx + 0x98]
            //   8974240c             | mov                 dword ptr [esp + 0xc], esi
            //   c7442404????????     |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax

        $sequence_7 = { 8b542428 8354242c00 83c340 836c242040 c1e206 39542414 0f87c3feffff }
            // n = 7, score = 100
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   8354242c00           | adc                 dword ptr [esp + 0x2c], 0
            //   83c340               | add                 ebx, 0x40
            //   836c242040           | sub                 dword ptr [esp + 0x20], 0x40
            //   c1e206               | shl                 edx, 6
            //   39542414             | cmp                 dword ptr [esp + 0x14], edx
            //   0f87c3feffff         | ja                  0xfffffec9

        $sequence_8 = { ffd6 83f8ff 75de 81c4cc0f0000 89e8 5b 5e }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   83f8ff               | cmp                 eax, -1
            //   75de                 | jne                 0xffffffe0
            //   81c4cc0f0000         | add                 esp, 0xfcc
            //   89e8                 | mov                 eax, ebp
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_9 = { 8906 8b7413fc 897411fc 8b7d14 89de 81c784000000 }
            // n = 6, score = 100
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b7413fc             | mov                 esi, dword ptr [ebx + edx - 4]
            //   897411fc             | mov                 dword ptr [ecx + edx - 4], esi
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]
            //   89de                 | mov                 esi, ebx
            //   81c784000000         | add                 edi, 0x84

    condition:
        7 of them and filesize < 1425408
}