rule win_moonbounce_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moonbounce."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moonbounce"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4dd4 0500100000 83c418 8901 }
            // n = 4, score = 100
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   0500100000           | add                 eax, 0x1000
            //   83c418               | add                 esp, 0x18
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_1 = { b9???????? 2bc8 51 50 8b4508 83c014 50 }
            // n = 7, score = 100
            //   b9????????           |                     
            //   2bc8                 | sub                 ecx, eax
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c014               | add                 eax, 0x14
            //   50                   | push                eax

        $sequence_2 = { 8945d8 53 8d45dc 50 ff15???????? 8d45d0 8945f8 }
            // n = 7, score = 100
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   53                   | push                ebx
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_3 = { 034004 83780400 7798 8d8680000000 83780400 }
            // n = 5, score = 100
            //   034004               | add                 eax, dword ptr [eax + 4]
            //   83780400             | cmp                 dword ptr [eax + 4], 0
            //   7798                 | ja                  0xffffff9a
            //   8d8680000000         | lea                 eax, [esi + 0x80]
            //   83780400             | cmp                 dword ptr [eax + 4], 0

        $sequence_4 = { 57 57 83c60c 56 ff15???????? 5f }
            // n = 6, score = 100
            //   57                   | push                edi
            //   57                   | push                edi
            //   83c60c               | add                 esi, 0xc
            //   56                   | push                esi
            //   ff15????????         |                     
            //   5f                   | pop                 edi

        $sequence_5 = { ff7508 ff15???????? 6a40 6800300000 8d45fc 50 }
            // n = 6, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_6 = { 84c0 7518 8b4310 56 }
            // n = 4, score = 100
            //   84c0                 | test                al, al
            //   7518                 | jne                 0x1a
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   56                   | push                esi

        $sequence_7 = { 8365f400 8d5008 895508 8b5004 03cb 83c2f8 894df0 }
            // n = 7, score = 100
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   8d5008               | lea                 edx, [eax + 8]
            //   895508               | mov                 dword ptr [ebp + 8], edx
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   03cb                 | add                 ecx, ebx
            //   83c2f8               | add                 edx, -8
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx

        $sequence_8 = { 8b45f0 0fb70448 8b4f1c 8d0c81 8b4508 8b1c01 03d8 }
            // n = 7, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   0fb70448             | movzx               eax, word ptr [eax + ecx*2]
            //   8b4f1c               | mov                 ecx, dword ptr [edi + 0x1c]
            //   8d0c81               | lea                 ecx, [ecx + eax*4]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b1c01               | mov                 ebx, dword ptr [ecx + eax]
            //   03d8                 | add                 ebx, eax

        $sequence_9 = { 8d450c 50 ff750c 33db ff15???????? }
            // n = 5, score = 100
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   33db                 | xor                 ebx, ebx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 70912
}