rule win_moonwalk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moonwalk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moonwalk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d4c2458 4c8978d0 4533ff 4c897c2458 44897d20 e8???????? 85c0 }
            // n = 7, score = 100
            //   488d4c2458           | dec                 esp
            //   4c8978d0             | mov                 dword ptr [esp + 0x30], esi
            //   4533ff               | dec                 esp
            //   4c897c2458           | mov                 dword ptr [esp + 0x28], esi
            //   44897d20             | dec                 eax
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [esp + 0x20], 0x2000

        $sequence_1 = { 488b0d???????? ba833fd2f8 41b8e8c5ba5b 48898140010000 488d0d17880000 e8???????? }
            // n = 6, score = 100
            //   488b0d????????       |                     
            //   ba833fd2f8           | dec                 esp
            //   41b8e8c5ba5b         | mov                 edi, ecx
            //   48898140010000       | dec                 esp
            //   488d0d17880000       | mov                 ecx, dword ptr [eax + 0x60]
            //   e8????????           |                     

        $sequence_2 = { 488b05???????? 4c8bb42418050000 4885c0 753c 488d8548040000 4489bd48040000 33d2 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   4c8bb42418050000     | xor                 esi, esi
            //   4885c0               | dec                 eax
            //   753c                 | mov                 dword ptr [esp + 0x28], ebp
            //   488d8548040000       | dec                 eax
            //   4489bd48040000       | mov                 dword ptr [esp + 0x20], esi
            //   33d2                 | dec                 eax

        $sequence_3 = { 72ed 443bc2 0f844e020000 33c0 44899500020000 89456c 0f57c0 }
            // n = 7, score = 100
            //   72ed                 | cmp                 esi, 0xf
            //   443bc2               | jne                 0xcb
            //   0f844e020000         | inc                 ebp
            //   33c0                 | xor                 edi, edi
            //   44899500020000       | dec                 esp
            //   89456c               | mov                 ecx, dword ptr [esp + 0x28]
            //   0f57c0               | inc                 ebp

        $sequence_4 = { 4881c4b0000000 5e c3 488b4718 488b4f20 ff5068 488d942490000000 }
            // n = 7, score = 100
            //   4881c4b0000000       | add                 ecx, 0x303c8
            //   5e                   | test                byte ptr [ecx], 2
            //   c3                   | jne                 0x1de0
            //   488b4718             | dec                 eax
            //   488b4f20             | inc                 eax
            //   ff5068               | dec                 eax
            //   488d942490000000     | cmp                 eax, 4

        $sequence_5 = { 488b4968 4c896c2438 4c896c2430 4c896c2428 4c896c2420 e8???????? 4885db }
            // n = 7, score = 100
            //   488b4968             | dec                 eax
            //   4c896c2438           | mov                 ecx, dword ptr [ecx + 0x20]
            //   4c896c2430           | dec                 eax
            //   4c896c2428           | mov                 dword ptr [esp + 0x38], edi
            //   4c896c2420           | dec                 eax
            //   e8????????           |                     
            //   4885db               | mov                 dword ptr [esp + 0x50], edi

        $sequence_6 = { 488d0508ecffff 48894360 488d05bdf4ffff 48894368 488d05b2f5ffff 48894370 488d05c7f7ffff }
            // n = 7, score = 100
            //   488d0508ecffff       | mov                 dword ptr [ecx + 0x1a0], eax
            //   48894360             | dec                 eax
            //   488d05bdf4ffff       | lea                 ecx, [0x868b]
            //   48894368             | mov                 edx, 0xf8d23f83
            //   488d05b2f5ffff       | inc                 ecx
            //   48894370             | mov                 eax, 0xebb7b00
            //   488d05c7f7ffff       | dec                 eax

        $sequence_7 = { 488bfa 440fb65104 440fb64908 440fb6410c }
            // n = 4, score = 100
            //   488bfa               | xor                 ebx, esi
            //   440fb65104           | inc                 ebp
            //   440fb64908           | mov                 dword ptr [esp + 0x88], ecx
            //   440fb6410c           | inc                 ebp

        $sequence_8 = { 4154 4155 4156 4157 488dac2458feffff 4881ecb8020000 0f1005???????? }
            // n = 7, score = 100
            //   4154                 | inc                 esp
            //   4155                 | mov                 dword ptr [esp + 0x20], ebx
            //   4156                 | add                 edx, eax
            //   4157                 | inc                 ecx
            //   488dac2458feffff     | shl                 eax, 8
            //   4881ecb8020000       | inc                 ecx
            //   0f1005????????       |                     

        $sequence_9 = { 0f84b6000000 4183f81d 740a b810000000 4883c448 c3 48895c2440 }
            // n = 7, score = 100
            //   0f84b6000000         | cmp                 ecx, 4
            //   4183f81d             | inc                 ecx
            //   740a                 | movups              xmm2, xmmword ptr [edx + 0x10]
            //   b810000000           | inc                 ecx
            //   4883c448             | movups              xmm3, xmmword ptr [edx + 0x20]
            //   c3                   | inc                 ecx
            //   48895c2440           | movups              xmm4, xmmword ptr [edx + 0x30]

    condition:
        7 of them and filesize < 179200
}