rule win_moonwind_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.moonwind."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moonwind"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b90f000000 f3ab 83c308 b800000000 }
            // n = 4, score = 100
            //   b90f000000           | mov                 ecx, 0xf
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   83c308               | add                 ebx, 8
            //   b800000000           | mov                 eax, 0

        $sequence_1 = { 83c404 03d8 895dec 8965e8 6828000000 8b45f0 50 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   03d8                 | add                 ebx, eax
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   6828000000           | push                0x28
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   50                   | push                eax

        $sequence_2 = { 3965a8 740d 6806000000 e8???????? 83c404 50 8b5da4 }
            // n = 7, score = 100
            //   3965a8               | cmp                 dword ptr [ebp - 0x58], esp
            //   740d                 | je                  0xf
            //   6806000000           | push                6
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   8b5da4               | mov                 ebx, dword ptr [ebp - 0x5c]

        $sequence_3 = { 83c404 8b45ec 50 8b1d???????? 85db 7409 53 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   8b1d????????         |                     
            //   85db                 | test                ebx, ebx
            //   7409                 | je                  0xb
            //   53                   | push                ebx

        $sequence_4 = { e8???????? 83c428 8945ac 8b45ac 50 8b5dd8 53 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   8b45ac               | mov                 eax, dword ptr [ebp - 0x54]
            //   50                   | push                eax
            //   8b5dd8               | mov                 ebx, dword ptr [ebp - 0x28]
            //   53                   | push                ebx

        $sequence_5 = { 68000000c0 ff750c e8???????? a3???????? 833d????????ff 0f84b2000000 e8???????? }
            // n = 7, score = 100
            //   68000000c0           | push                0xc0000000
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   a3????????           |                     
            //   833d????????ff       |                     
            //   0f84b2000000         | je                  0xb8
            //   e8????????           |                     

        $sequence_6 = { 6824000000 e8???????? 83c404 a3???????? 8bd8 8bf8 }
            // n = 6, score = 100
            //   6824000000           | push                0x24
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   a3????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   8bf8                 | mov                 edi, eax

        $sequence_7 = { 8b5d08 8b1b 83c304 895dfc 8965f8 6805000000 8b5dfc }
            // n = 7, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   83c304               | add                 ebx, 4
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8965f8               | mov                 dword ptr [ebp - 8], esp
            //   6805000000           | push                5
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]

        $sequence_8 = { 53 8903 8bd8 c70300000000 c7430400000000 5b 8b5d08 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8bd8                 | mov                 ebx, eax
            //   c70300000000         | mov                 dword ptr [ebx], 0
            //   c7430400000000       | mov                 dword ptr [ebx + 4], 0
            //   5b                   | pop                 ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_9 = { 51 8d542478 8944247c 6a00 52 40 6a00 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d542478             | lea                 edx, [esp + 0x78]
            //   8944247c             | mov                 dword ptr [esp + 0x7c], eax
            //   6a00                 | push                0
            //   52                   | push                edx
            //   40                   | inc                 eax
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 1417216
}