rule win_mortis_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mortis."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mortis"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6bcf38 030c95201f4400 f6412d01 7428 e8???????? c70016000000 e8???????? }
            // n = 7, score = 100
            //   6bcf38               | imul                ecx, edi, 0x38
            //   030c95201f4400       | add                 ecx, dword ptr [edx*4 + 0x441f20]
            //   f6412d01             | test                byte ptr [ecx + 0x2d], 1
            //   7428                 | je                  0x2a
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     

        $sequence_1 = { 68???????? 51 50 51 ffb54cfdffff 8d4d98 e8???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   51                   | push                ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ffb54cfdffff         | push                dword ptr [ebp - 0x2b4]
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   e8????????           |                     

        $sequence_2 = { 8d1476 c1e204 8d0476 57 03d7 8d0cc7 e8???????? }
            // n = 7, score = 100
            //   8d1476               | lea                 edx, [esi + esi*2]
            //   c1e204               | shl                 edx, 4
            //   8d0476               | lea                 eax, [esi + esi*2]
            //   57                   | push                edi
            //   03d7                 | add                 edx, edi
            //   8d0cc7               | lea                 ecx, [edi + eax*8]
            //   e8????????           |                     

        $sequence_3 = { 8d8d40feffff 6a00 034804 33c0 394138 0f94c0 8d048502000000 }
            // n = 7, score = 100
            //   8d8d40feffff         | lea                 ecx, [ebp - 0x1c0]
            //   6a00                 | push                0
            //   034804               | add                 ecx, dword ptr [eax + 4]
            //   33c0                 | xor                 eax, eax
            //   394138               | cmp                 dword ptr [ecx + 0x38], eax
            //   0f94c0               | sete                al
            //   8d048502000000       | lea                 eax, [eax*4 + 2]

        $sequence_4 = { c645fc01 8d8da0fdffff 6a07 0f57c0 c785b0fdffff00000000 68???????? 0f1185a0fdffff }
            // n = 7, score = 100
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8d8da0fdffff         | lea                 ecx, [ebp - 0x260]
            //   6a07                 | push                7
            //   0f57c0               | xorps               xmm0, xmm0
            //   c785b0fdffff00000000     | mov    dword ptr [ebp - 0x250], 0
            //   68????????           |                     
            //   0f1185a0fdffff       | movups              xmmword ptr [ebp - 0x260], xmm0

        $sequence_5 = { f20f591485d08c4300 660f5834c5e0944300 660f54c5 f20f5ce8 f20f58fa f20f10d8 f20f59c1 }
            // n = 7, score = 100
            //   f20f591485d08c4300     | mulsd    xmm2, qword ptr [eax*4 + 0x438cd0]
            //   660f5834c5e0944300     | addpd    xmm6, xmmword ptr [eax*8 + 0x4394e0]
            //   660f54c5             | andpd               xmm0, xmm5
            //   f20f5ce8             | subsd               xmm5, xmm0
            //   f20f58fa             | addsd               xmm7, xmm2
            //   f20f10d8             | movsd               xmm3, xmm0
            //   f20f59c1             | mulsd               xmm0, xmm1

        $sequence_6 = { 8b07 6a01 68???????? 51 50 51 ffb54cfdffff }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   6a01                 | push                1
            //   68????????           |                     
            //   51                   | push                ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ffb54cfdffff         | push                dword ptr [ebp - 0x2b4]

        $sequence_7 = { c60000 c645fc04 8b8d3cfdffff 83f910 722f 8b9528fdffff 41 }
            // n = 7, score = 100
            //   c60000               | mov                 byte ptr [eax], 0
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8b8d3cfdffff         | mov                 ecx, dword ptr [ebp - 0x2c4]
            //   83f910               | cmp                 ecx, 0x10
            //   722f                 | jb                  0x31
            //   8b9528fdffff         | mov                 edx, dword ptr [ebp - 0x2d8]
            //   41                   | inc                 ecx

        $sequence_8 = { 7544 ba???????? b9???????? e8???????? 8bf0 ff15???????? }
            // n = 6, score = 100
            //   7544                 | jne                 0x46
            //   ba????????           |                     
            //   b9????????           |                     
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     

        $sequence_9 = { 68???????? 0f1185e8fdffff c785fcfdffff00000000 e8???????? c645fc05 8d8d00feffff 6a0a }
            // n = 7, score = 100
            //   68????????           |                     
            //   0f1185e8fdffff       | movups              xmmword ptr [ebp - 0x218], xmm0
            //   c785fcfdffff00000000     | mov    dword ptr [ebp - 0x204], 0
            //   e8????????           |                     
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   8d8d00feffff         | lea                 ecx, [ebp - 0x200]
            //   6a0a                 | push                0xa

    condition:
        7 of them and filesize < 577536
}