rule win_mrdec_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mrdec."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mrdec"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c64446fa00 57 56 e8???????? 68???????? 56 e8???????? }
            // n = 7, score = 100
            //   c64446fa00           | mov                 byte ptr [esi + eax*2 - 6], 0
            //   57                   | push                edi
            //   56                   | push                esi
            //   e8????????           |                     
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_1 = { 6a00 8d45cc 50 68ef000000 68???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   68ef000000           | push                0xef
            //   68????????           |                     

        $sequence_2 = { 50 ff75f0 6a00 6a00 6a00 ff75e8 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   e8????????           |                     

        $sequence_3 = { 7532 68dc050000 ff75dc 68???????? e8???????? }
            // n = 5, score = 100
            //   7532                 | jne                 0x34
            //   68dc050000           | push                0x5dc
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 6a00 6814010000 68???????? ff75d8 e8???????? 8d3550514000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6814010000           | push                0x114
            //   68????????           |                     
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   e8????????           |                     
            //   8d3550514000         | lea                 esi, [0x405150]

        $sequence_5 = { 8bec ff7508 6a40 e8???????? 0bc0 750c 68c8000000 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a40                 | push                0x40
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   750c                 | jne                 0xe
            //   68c8000000           | push                0xc8

        $sequence_6 = { 81c700020000 68???????? 57 e8???????? 68???????? 57 e8???????? }
            // n = 7, score = 100
            //   81c700020000         | add                 edi, 0x200
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_7 = { 59 51 80c141 884808 ff05???????? 6a00 6a00 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   51                   | push                ecx
            //   80c141               | add                 cl, 0x41
            //   884808               | mov                 byte ptr [eax + 8], cl
            //   ff05????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 6a02 e8???????? 0bc0 0f8530010000 c745f000400000 ff75f0 }
            // n = 6, score = 100
            //   6a02                 | push                2
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax
            //   0f8530010000         | jne                 0x136
            //   c745f000400000       | mov                 dword ptr [ebp - 0x10], 0x4000
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_9 = { 6a00 6a00 e8???????? ff75dc e8???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   e8????????           |                     
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 44864
}