rule win_multigrain_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.multigrain_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.multigrain_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 68???????? eb25 807dec00 7504 33c9 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   eb25                 | jmp                 0x27
            //   807dec00             | cmp                 byte ptr [ebp - 0x14], 0
            //   7504                 | jne                 6
            //   33c9                 | xor                 ecx, ecx

        $sequence_1 = { 8b13 50 8d8d6cffffff e8???????? 83ec18 }
            // n = 5, score = 200
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   50                   | push                eax
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18

        $sequence_2 = { 66894508 720b ff7520 e8???????? 83c404 8ac3 }
            // n = 6, score = 200
            //   66894508             | mov                 word ptr [ebp + 8], ax
            //   720b                 | jb                  0xd
            //   ff7520               | push                dword ptr [ebp + 0x20]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8ac3                 | mov                 al, bl

        $sequence_3 = { c746140f000000 c7461000000000 68???????? 8bce c745fc00000000 }
            // n = 5, score = 200
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_4 = { c7411000000000 50 c60100 e8???????? 8d8da4feffff }
            // n = 5, score = 200
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   50                   | push                eax
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   8d8da4feffff         | lea                 ecx, [ebp - 0x15c]

        $sequence_5 = { 83f908 720d 8b0e 50 8d145a e8???????? eb2c }
            // n = 7, score = 200
            //   83f908               | cmp                 ecx, 8
            //   720d                 | jb                  0xf
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   50                   | push                eax
            //   8d145a               | lea                 edx, [edx + ebx*2]
            //   e8????????           |                     
            //   eb2c                 | jmp                 0x2e

        $sequence_6 = { e8???????? 68???????? 8bd0 8d4dd8 c645fc03 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   68????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   e8????????           |                     

        $sequence_7 = { 1bc0 f7d8 5e 5d c20800 85f6 750f }
            // n = 7, score = 200
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   85f6                 | test                esi, esi
            //   750f                 | jne                 0x11

        $sequence_8 = { 50 888534ffffff 8d8535ffffff 50 e8???????? 83c40c }
            // n = 6, score = 200
            //   50                   | push                eax
            //   888534ffffff         | mov                 byte ptr [ebp - 0xcc], al
            //   8d8535ffffff         | lea                 eax, [ebp - 0xcb]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { 837d1c10 8bd8 8d4508 0f434508 56 }
            // n = 5, score = 200
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10
            //   8bd8                 | mov                 ebx, eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   0f434508             | cmovae              eax, dword ptr [ebp + 8]
            //   56                   | push                esi

    condition:
        7 of them and filesize < 286720
}