rule win_murkytop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.murkytop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.murkytop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc6 c1f805 57 83e61f 8d3c85e0f54100 8b07 }
            // n = 6, score = 100
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   57                   | push                edi
            //   83e61f               | and                 esi, 0x1f
            //   8d3c85e0f54100       | lea                 edi, [eax*4 + 0x41f5e0]
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_1 = { 0f8827040000 8b5d08 8d7dec e8???????? 85c0 0f8814040000 6803010000 }
            // n = 7, score = 100
            //   0f8827040000         | js                  0x42d
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8d7dec               | lea                 edi, [ebp - 0x14]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8814040000         | js                  0x41a
            //   6803010000           | push                0x103

        $sequence_2 = { 50 68???????? e8???????? 8b45fc 8b4868 51 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4868               | mov                 ecx, dword ptr [eax + 0x68]
            //   51                   | push                ecx

        $sequence_3 = { 8b4de8 51 68???????? e8???????? 8b55f0 }
            // n = 5, score = 100
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   51                   | push                ecx
            //   68????????           |                     
            //   e8????????           |                     
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_4 = { 3bc6 7377 8bce e8???????? c745fc00000000 }
            // n = 5, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   7377                 | jae                 0x79
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_5 = { 50 68???????? e8???????? 8b45fc 8b4824 51 e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4824               | mov                 ecx, dword ptr [eax + 0x24]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_6 = { 7551 8b4d08 85c9 745e 8b7918 b889888888 f7ef }
            // n = 7, score = 100
            //   7551                 | jne                 0x53
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   85c9                 | test                ecx, ecx
            //   745e                 | je                  0x60
            //   8b7918               | mov                 edi, dword ptr [ecx + 0x18]
            //   b889888888           | mov                 eax, 0x88888889
            //   f7ef                 | imul                edi

        $sequence_7 = { 3bc7 7629 8bcf 8bd1 d1ea beffffff3f 2bf2 }
            // n = 7, score = 100
            //   3bc7                 | cmp                 eax, edi
            //   7629                 | jbe                 0x2b
            //   8bcf                 | mov                 ecx, edi
            //   8bd1                 | mov                 edx, ecx
            //   d1ea                 | shr                 edx, 1
            //   beffffff3f           | mov                 esi, 0x3fffffff
            //   2bf2                 | sub                 esi, edx

        $sequence_8 = { b902000000 66894dc4 53 ff15???????? 668945c6 }
            // n = 5, score = 100
            //   b902000000           | mov                 ecx, 2
            //   66894dc4             | mov                 word ptr [ebp - 0x3c], cx
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   668945c6             | mov                 word ptr [ebp - 0x3a], ax

        $sequence_9 = { 3c69 7404 3c49 757f c645fa01 e9???????? c645fe01 }
            // n = 7, score = 100
            //   3c69                 | cmp                 al, 0x69
            //   7404                 | je                  6
            //   3c49                 | cmp                 al, 0x49
            //   757f                 | jne                 0x81
            //   c645fa01             | mov                 byte ptr [ebp - 6], 1
            //   e9????????           |                     
            //   c645fe01             | mov                 byte ptr [ebp - 2], 1

    condition:
        7 of them and filesize < 294912
}