rule win_mydoom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mydoom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mydoom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89442404 893424 e8???????? ba00000000 eb20 ba00000000 }
            // n = 6, score = 100
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   ba00000000           | mov                 edx, 0
            //   eb20                 | jmp                 0x22
            //   ba00000000           | mov                 edx, 0

        $sequence_1 = { 8d45f8 89442410 c744240c19000200 c744240800000000 895c2404 }
            // n = 5, score = 100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   c744240c19000200     | mov                 dword ptr [esp + 0xc], 0x20019
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   895c2404             | mov                 dword ptr [esp + 4], ebx

        $sequence_2 = { c3 55 89e5 83ec48 895df4 8975f8 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec48               | sub                 esp, 0x48
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   8975f8               | mov                 dword ptr [ebp - 8], esi

        $sequence_3 = { e8???????? c78538feffff44000000 c78564feffff01000000 66c78568feffff0500 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   c78538feffff44000000     | mov    dword ptr [ebp - 0x1c8], 0x44
            //   c78564feffff01000000     | mov    dword ptr [ebp - 0x19c], 1
            //   66c78568feffff0500     | mov    word ptr [ebp - 0x198], 5

        $sequence_4 = { 53 81ec94010000 c7442404???????? 8d9d38ffffff 891c24 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   81ec94010000         | sub                 esp, 0x194
            //   c7442404????????     |                     
            //   8d9d38ffffff         | lea                 ebx, [ebp - 0xc8]
            //   891c24               | mov                 dword ptr [esp], ebx

        $sequence_5 = { c7042401000080 e8???????? 83ec14 85c0 7547 893424 e8???????? }
            // n = 7, score = 100
            //   c7042401000080       | mov                 dword ptr [esp], 0x80000001
            //   e8????????           |                     
            //   83ec14               | sub                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   7547                 | jne                 0x49
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     

        $sequence_6 = { 380a 7415 42 803a00 7406 }
            // n = 5, score = 100
            //   380a                 | cmp                 byte ptr [edx], cl
            //   7415                 | je                  0x17
            //   42                   | inc                 edx
            //   803a00               | cmp                 byte ptr [edx], 0
            //   7406                 | je                  8

        $sequence_7 = { 8d85c8fdffff 890424 e8???????? 83ec04 8b4508 890424 e8???????? }
            // n = 7, score = 100
            //   8d85c8fdffff         | lea                 eax, [ebp - 0x238]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

        $sequence_8 = { 8945cc 0fb745e6 668945ca c744240810000000 8d45c8 }
            // n = 5, score = 100
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   0fb745e6             | movzx               eax, word ptr [ebp - 0x1a]
            //   668945ca             | mov                 word ptr [ebp - 0x36], ax
            //   c744240810000000     | mov                 dword ptr [esp + 8], 0x10
            //   8d45c8               | lea                 eax, [ebp - 0x38]

        $sequence_9 = { 8b7508 8b5d0c 803b00 7414 0fbe03 }
            // n = 5, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   803b00               | cmp                 byte ptr [ebx], 0
            //   7414                 | je                  0x16
            //   0fbe03               | movsx               eax, byte ptr [ebx]

    condition:
        7 of them and filesize < 114688
}