rule win_mystic_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.mystic_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mystic_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7509 3bef 7505 33db 43 eb02 33db }
            // n = 7, score = 200
            //   7509                 | jne                 0xb
            //   3bef                 | cmp                 ebp, edi
            //   7505                 | jne                 7
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx
            //   eb02                 | jmp                 4
            //   33db                 | xor                 ebx, ebx

        $sequence_1 = { 741f 8b0e 50 8b510c e8???????? 8b06 59 }
            // n = 7, score = 200
            //   741f                 | je                  0x21
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   50                   | push                eax
            //   8b510c               | mov                 edx, dword ptr [ecx + 0xc]
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   59                   | pop                 ecx

        $sequence_2 = { 3b5c242c 7f59 66ff84463c0b0000 33c9 }
            // n = 4, score = 200
            //   3b5c242c             | cmp                 ebx, dword ptr [esp + 0x2c]
            //   7f59                 | jg                  0x5b
            //   66ff84463c0b0000     | inc                 word ptr [esi + eax*2 + 0xb3c]
            //   33c9                 | xor                 ecx, ecx

        $sequence_3 = { e8???????? 83bd5014000002 59 59 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83bd5014000002       | cmp                 dword ptr [ebp + 0x1450], 2
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_4 = { 8bc2 41 3bca 8b542418 0f4ec1 8b4c2414 89442430 }
            // n = 7, score = 200
            //   8bc2                 | mov                 eax, edx
            //   41                   | inc                 ecx
            //   3bca                 | cmp                 ecx, edx
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   0f4ec1               | cmovle              eax, ecx
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   89442430             | mov                 dword ptr [esp + 0x30], eax

        $sequence_5 = { 8bcf c7460471000000 e8???????? 33c9 394e14 }
            // n = 5, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   c7460471000000       | mov                 dword ptr [esi + 4], 0x71
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   394e14               | cmp                 dword ptr [esi + 0x14], ecx

        $sequence_6 = { 5b e9???????? a1???????? 8bcf c746049a020000 894718 e8???????? }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   e9????????           |                     
            //   a1????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   c746049a020000       | mov                 dword ptr [esi + 4], 0x29a
            //   894718               | mov                 dword ptr [edi + 0x18], eax
            //   e8????????           |                     

        $sequence_7 = { 3bca 7420 0fb7449d02 8bca }
            // n = 4, score = 200
            //   3bca                 | cmp                 ecx, edx
            //   7420                 | je                  0x22
            //   0fb7449d02           | movzx               eax, word ptr [ebp + ebx*4 + 2]
            //   8bca                 | mov                 ecx, edx

        $sequence_8 = { 80ea03 c6040101 8b8ea0160000 8b8698160000 41 898ea0160000 c6040100 }
            // n = 7, score = 200
            //   80ea03               | sub                 dl, 3
            //   c6040101             | mov                 byte ptr [ecx + eax], 1
            //   8b8ea0160000         | mov                 ecx, dword ptr [esi + 0x16a0]
            //   8b8698160000         | mov                 eax, dword ptr [esi + 0x1698]
            //   41                   | inc                 ecx
            //   898ea0160000         | mov                 dword ptr [esi + 0x16a0], ecx
            //   c6040100             | mov                 byte ptr [ecx + eax], 0

        $sequence_9 = { 57 ffb42444010000 ffb4244c010000 50 }
            // n = 4, score = 200
            //   57                   | push                edi
            //   ffb42444010000       | push                dword ptr [esp + 0x144]
            //   ffb4244c010000       | push                dword ptr [esp + 0x14c]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 465920
}