rule win_n40_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.n40"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945d0 a1???????? 50 8b4dd0 33d2 a1???????? e8???????? }
            // n = 7, score = 100
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   a1????????           |                     
            //   50                   | push                eax
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   33d2                 | xor                 edx, edx
            //   a1????????           |                     
            //   e8????????           |                     

        $sequence_1 = { 8945ec 8d55d4 8b45fc 8b80f8030000 e8???????? 8b45d4 8945e8 }
            // n = 7, score = 100
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8d55d4               | lea                 edx, [ebp - 0x2c]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b80f8030000         | mov                 eax, dword ptr [eax + 0x3f8]
            //   e8????????           |                     
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_2 = { 03c2 05f36f2e68 0345ac 8945d8 8b45f4 c1e802 8b55f4 }
            // n = 7, score = 100
            //   03c2                 | add                 eax, edx
            //   05f36f2e68           | add                 eax, 0x682e6ff3
            //   0345ac               | add                 eax, dword ptr [ebp - 0x54]
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c1e802               | shr                 eax, 2
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_3 = { 8b45f8 03c3 8b55fc 0fb60402 240f 0fb6c0 0fb70445fc21e102 }
            // n = 7, score = 100
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   03c3                 | add                 eax, ebx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fb60402             | movzx               eax, byte ptr [edx + eax]
            //   240f                 | and                 al, 0xf
            //   0fb6c0               | movzx               eax, al
            //   0fb70445fc21e102     | movzx               eax, word ptr [eax*2 + 0x2e121fc]

        $sequence_4 = { 83c4a0 8955f8 8945fc c645f700 33c0 8945dc 68???????? }
            // n = 7, score = 100
            //   83c4a0               | add                 esp, -0x60
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c645f700             | mov                 byte ptr [ebp - 9], 0
            //   33c0                 | xor                 eax, eax
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   68????????           |                     

        $sequence_5 = { b90e000000 a1???????? 8b18 ff5310 ba???????? b928000000 a1???????? }
            // n = 7, score = 100
            //   b90e000000           | mov                 ecx, 0xe
            //   a1????????           |                     
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   ff5310               | call                dword ptr [ebx + 0x10]
            //   ba????????           |                     
            //   b928000000           | mov                 ecx, 0x28
            //   a1????????           |                     

        $sequence_6 = { 8b45f4 50 8b45f8 50 8b45fc 50 ff55ec }
            // n = 7, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff55ec               | call                dword ptr [ebp - 0x14]

        $sequence_7 = { ff5248 baf4010000 a1???????? e8???????? 8d8d38fdffff ba1c000000 8b45fc }
            // n = 7, score = 100
            //   ff5248               | call                dword ptr [edx + 0x48]
            //   baf4010000           | mov                 edx, 0x1f4
            //   a1????????           |                     
            //   e8????????           |                     
            //   8d8d38fdffff         | lea                 ecx, [ebp - 0x2c8]
            //   ba1c000000           | mov                 edx, 0x1c
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_8 = { 8b45fc f6400120 751d 55 8d55ec 8b45fc e8???????? }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   f6400120             | test                byte ptr [eax + 1], 0x20
            //   751d                 | jne                 0x1f
            //   55                   | push                ebp
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_9 = { 7414 8b45dc 0d00000800 50 6aec 8b45fc 50 }
            // n = 7, score = 100
            //   7414                 | je                  0x16
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   0d00000800           | or                  eax, 0x80000
            //   50                   | push                eax
            //   6aec                 | push                -0x14
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 19390464
}