rule win_nachocheese_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nachocheese."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nachocheese"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bfa 8d47fd 3901 8901 }
            // n = 4, score = 300
            //   2bfa                 | sub                 edi, edx
            //   8d47fd               | lea                 eax, [edi - 3]
            //   3901                 | cmp                 dword ptr [ecx], eax
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_1 = { 3d2cc00000 7f18 3d2bc00000 7d1b }
            // n = 4, score = 300
            //   3d2cc00000           | cmp                 eax, 0xc02c
            //   7f18                 | jg                  0x1a
            //   3d2bc00000           | cmp                 eax, 0xc02b
            //   7d1b                 | jge                 0x1d

        $sequence_2 = { 33c4 89842498210000 833d????????02 53 56 }
            // n = 5, score = 300
            //   33c4                 | xor                 eax, esp
            //   89842498210000       | mov                 dword ptr [esp + 0x2198], eax
            //   833d????????02       |                     
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_3 = { 3d9c000000 7c07 3d9f000000 7e0d }
            // n = 4, score = 300
            //   3d9c000000           | cmp                 eax, 0x9c
            //   7c07                 | jl                  9
            //   3d9f000000           | cmp                 eax, 0x9f
            //   7e0d                 | jle                 0xf

        $sequence_4 = { 8b5f18 85f6 7504 33c0 eb1e }
            // n = 5, score = 300
            //   8b5f18               | mov                 ebx, dword ptr [edi + 0x18]
            //   85f6                 | test                esi, esi
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb1e                 | jmp                 0x20

        $sequence_5 = { 83c404 8975fc 8d4900 e8???????? 8bf0 85f6 }
            // n = 6, score = 300
            //   83c404               | add                 esp, 4
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8d4900               | lea                 ecx, [ecx]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_6 = { 8d4813 894dec 8955fc 53 }
            // n = 4, score = 300
            //   8d4813               | lea                 ecx, [eax + 0x13]
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   53                   | push                ebx

        $sequence_7 = { 3d2bc00000 7d1b 3d9c000000 7c07 }
            // n = 4, score = 300
            //   3d2bc00000           | cmp                 eax, 0xc02b
            //   7d1b                 | jge                 0x1d
            //   3d9c000000           | cmp                 eax, 0x9c
            //   7c07                 | jl                  9

        $sequence_8 = { 81fb80000000 7305 83c302 eb29 81fb00010000 7305 }
            // n = 6, score = 300
            //   81fb80000000         | cmp                 ebx, 0x80
            //   7305                 | jae                 7
            //   83c302               | add                 ebx, 2
            //   eb29                 | jmp                 0x2b
            //   81fb00010000         | cmp                 ebx, 0x100
            //   7305                 | jae                 7

        $sequence_9 = { 5b 8be5 5d c20400 8d4508 50 681d002000 }
            // n = 7, score = 300
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   681d002000           | push                0x20001d

        $sequence_10 = { 33c8 894710 8b4708 33c1 }
            // n = 4, score = 300
            //   33c8                 | xor                 ecx, eax
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   33c1                 | xor                 eax, ecx

        $sequence_11 = { 33c0 c3 05d13fffff 83f801 }
            // n = 4, score = 300
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   05d13fffff           | add                 eax, 0xffff3fd1
            //   83f801               | cmp                 eax, 1

        $sequence_12 = { 83ec0c 53 56 57 33f6 6a03 }
            // n = 6, score = 300
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi
            //   6a03                 | push                3

        $sequence_13 = { 8b4508 8d55a8 52 33c9 50 }
            // n = 5, score = 300
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d55a8               | lea                 edx, [ebp - 0x58]
            //   52                   | push                edx
            //   33c9                 | xor                 ecx, ecx
            //   50                   | push                eax

        $sequence_14 = { 52 89bddcf9ffff e8???????? 83c404 }
            // n = 4, score = 300
            //   52                   | push                edx
            //   89bddcf9ffff         | mov                 dword ptr [ebp - 0x624], edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_15 = { 3d9f000000 7e0d 33c0 c3 }
            // n = 4, score = 300
            //   3d9f000000           | cmp                 eax, 0x9f
            //   7e0d                 | jle                 0xf
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 1064960
}