rule win_nagini_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nagini."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nagini"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 080c08 07 0d0807110c 0916 100b }
            // n = 5, score = 100
            //   080c08               | or                  byte ptr [eax + ecx], cl
            //   07                   | pop                 es
            //   0d0807110c           | or                  eax, 0xc110708
            //   0916                 | or                  dword ptr [esi], edx
            //   100b                 | adc                 byte ptr [ebx], cl

        $sequence_1 = { 83781408 7202 8b00 50 e8???????? 83c404 837c245808 }
            // n = 7, score = 100
            //   83781408             | cmp                 dword ptr [eax + 0x14], 8
            //   7202                 | jb                  4
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837c245808           | cmp                 dword ptr [esp + 0x58], 8

        $sequence_2 = { 0f835ffbffff 03f3 03d3 83fb1f 0f8715040000 ff249da0c64000 8b46e4 }
            // n = 7, score = 100
            //   0f835ffbffff         | jae                 0xfffffb65
            //   03f3                 | add                 esi, ebx
            //   03d3                 | add                 edx, ebx
            //   83fb1f               | cmp                 ebx, 0x1f
            //   0f8715040000         | ja                  0x41b
            //   ff249da0c64000       | jmp                 dword ptr [ebx*4 + 0x40c6a0]
            //   8b46e4               | mov                 eax, dword ptr [esi - 0x1c]

        $sequence_3 = { 0404 0406 0404 06 0404 06 0404 }
            // n = 7, score = 100
            //   0404                 | add                 al, 4
            //   0406                 | add                 al, 6
            //   0404                 | add                 al, 4
            //   06                   | push                es
            //   0404                 | add                 al, 4
            //   06                   | push                es
            //   0404                 | add                 al, 4

        $sequence_4 = { 0536240538 27 06 37 260537260535 230434 2203 }
            // n = 7, score = 100
            //   0536240538           | add                 eax, 0x38052436
            //   27                   | daa                 
            //   06                   | push                es
            //   37                   | aaa                 
            //   260537260535         | add                 eax, 0x35052637
            //   230434               | and                 eax, dword ptr [esp + esi]
            //   2203                 | and                 al, byte ptr [ebx]

        $sequence_5 = { 07 0505080606 0907 07 }
            // n = 4, score = 100
            //   07                   | pop                 es
            //   0505080606           | add                 eax, 0x6060805
            //   0907                 | or                  dword ptr [edi], eax
            //   07                   | pop                 es

        $sequence_6 = { 6a14 8d0440 3d860a0000 756c 6a32 68a0000000 }
            // n = 6, score = 100
            //   6a14                 | push                0x14
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   3d860a0000           | cmp                 eax, 0xa86
            //   756c                 | jne                 0x6e
            //   6a32                 | push                0x32
            //   68a0000000           | push                0xa0

        $sequence_7 = { 6454 48 68584c6959 4d 6f 5f 53 }
            // n = 7, score = 100
            //   6454                 | push                esp
            //   48                   | dec                 eax
            //   68584c6959           | push                0x59694c58
            //   4d                   | dec                 ebp
            //   6f                   | outsd               dx, dword ptr [esi]
            //   5f                   | pop                 edi
            //   53                   | push                ebx

        $sequence_8 = { 06 0806 06 0907 }
            // n = 4, score = 100
            //   06                   | push                es
            //   0806                 | or                  byte ptr [esi], al
            //   06                   | push                es
            //   0907                 | or                  dword ptr [edi], eax

        $sequence_9 = { 89441928 8b45f0 8954192c 8b4df4 8b148dc0914200 }
            // n = 5, score = 100
            //   89441928             | mov                 dword ptr [ecx + ebx + 0x28], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8954192c             | mov                 dword ptr [ecx + ebx + 0x2c], edx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b148dc0914200       | mov                 edx, dword ptr [ecx*4 + 0x4291c0]

    condition:
        7 of them and filesize < 12820480
}