rule win_naplistener_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.naplistener."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.naplistener"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 18 8d01000001 1316 1116 16 110a }
            // n = 6, score = 100
            //   18                   | add                 byte ptr [edx], cl
            //   8d01000001           | or                  dword ptr [esi + 0x366f6a69], ecx
            //   1316                 | add                 byte ptr [eax], al
            //   1116                 | or                  al, byte ptr [eax]
            //   16                   | or                  dword ptr [esi + 0x376f69], ecx
            //   110a                 | add                 byte ptr [edx], cl

        $sequence_1 = { 38bbfdffff 1314 00 7251010070 }
            // n = 4, score = 100
            //   38bbfdffff           | sub                 byte ptr [esi], al
            //   1314                 | add                 byte ptr [eax], al
            //   00                   | or                  al, byte ptr [eax]
            //   7251010070           | pop                 es

        $sequence_2 = { 7285000070 0c 06 6f0e00000a }
            // n = 4, score = 100
            //   7285000070           | and                 dword ptr [eax], eax
            //   0c                   | add                 byte ptr [edx], cl
            //   06                   | outsd               dx, dword ptr [esi]
            //   6f0e00000a           | and                 dword ptr [eax], eax

        $sequence_3 = { 110c 110b 1110 6f2600000a }
            // n = 4, score = 100
            //   110c                 | pop                 es
            //   110b                 | adc                 al, 0xfe
            //   1110                 | add                 dword ptr [ebx], edx
            //   6f2600000a           | adc                 eax, 0x396f0711

        $sequence_4 = { 6f2600000a 00 1106 6f2700000a 732800000a 1311 1111 }
            // n = 7, score = 100
            //   6f2600000a           | cmp                 al, byte ptr [eax]
            //   00                   | add                 byte ptr [edx], cl
            //   1106                 | add                 byte ptr [eax], al
            //   6f2700000a           | adc                 dword ptr [edi], eax
            //   732800000a           | outsd               dx, dword ptr [esi]
            //   1311                 | cmp                 al, byte ptr [eax]
            //   1111                 | add                 byte ptr [edx], cl

        $sequence_5 = { 00 de3a 00 1107 14 fe01 }
            // n = 6, score = 100
            //   00                   | adc                 dword ptr es:[eax], ecx
            //   de3a                 | outsd               dx, dword ptr [esi]
            //   00                   | xor                 al, byte ptr [eax]
            //   1107                 | add                 byte ptr [edx], cl
            //   14                   | adc                 dword ptr es:[eax], ecx
            //   fe01                 | outsd               dx, dword ptr [esi]

        $sequence_6 = { 6f2700000a 1307 1107 09 16 09 8e }
            // n = 7, score = 100
            //   6f2700000a           | add                 byte ptr [eax], al
            //   1307                 | adc                 dword ptr [esi], eax
            //   1107                 | outsd               dx, dword ptr [esi]
            //   09                   | daa                 
            //   16                   | add                 byte ptr [eax], al
            //   09                   | or                  ch, byte ptr [edi + 0x39]
            //   8e                   | add                 byte ptr [eax], al

        $sequence_7 = { 110e 1110 18 8d01000001 }
            // n = 4, score = 100
            //   110e                 | adc                 dword ptr es:[eax], ecx
            //   1110                 | adc                 dword ptr [eax], ecx
            //   18                   | outsd               dx, dword ptr [esi]
            //   8d01000001           | xor                 eax, dword ptr [eax]

        $sequence_8 = { 281900000a 1109 6f1a00000a 130a 7283000070 1105 6f1b00000a }
            // n = 7, score = 100
            //   281900000a           | or                  eax, 0x130a0000
            //   1109                 | adc                 eax, 0xdc001511
            //   6f1a00000a           | add                 byte ptr [eax], al
            //   130a                 | pop                 ss
            //   7283000070           | adc                 edx, dword ptr [0xfffdbb38]
            //   1105                 | inc                 dword ptr [eax]
            //   6f1b00000a           | frstor              dword ptr [edi + 0x72000002]

        $sequence_9 = { 06 6f3b00000a 16 fe01 }
            // n = 4, score = 100
            //   06                   | add                 byte ptr [edx], cl
            //   6f3b00000a           | pop                 ds
            //   16                   | sbb                 dh, byte ptr [edx + 1]
            //   fe01                 | add                 byte ptr [eax], al

    condition:
        7 of them and filesize < 50176
}