rule win_narilam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.narilam."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.narilam"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 66c785b0feffff2c03 ba???????? 8d85e0feffff e8???????? ff85bcfeffff 8d95e0feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   66c785b0feffff2c03     | mov    word ptr [ebp - 0x150], 0x32c
            //   ba????????           |                     
            //   8d85e0feffff         | lea                 eax, [ebp - 0x120]
            //   e8????????           |                     
            //   ff85bcfeffff         | inc                 dword ptr [ebp - 0x144]
            //   8d95e0feffff         | lea                 edx, [ebp - 0x120]

        $sequence_1 = { e8???????? 84c0 7434 8b4370 50 8d45d0 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7434                 | je                  0x36
            //   8b4370               | mov                 eax, dword ptr [ebx + 0x70]
            //   50                   | push                eax
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax

        $sequence_2 = { e8???????? 50 ff45d8 ba???????? 8d45f4 e8???????? ff45d8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff45d8               | inc                 dword ptr [ebp - 0x28]
            //   ba????????           |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   e8????????           |                     
            //   ff45d8               | inc                 dword ptr [ebp - 0x28]

        $sequence_3 = { ff8d4cfeffff 8d8548ffffff ba02000000 e8???????? 66c78540feffff0c02 ba???????? 8d8544ffffff }
            // n = 7, score = 100
            //   ff8d4cfeffff         | dec                 dword ptr [ebp - 0x1b4]
            //   8d8548ffffff         | lea                 eax, [ebp - 0xb8]
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   66c78540feffff0c02     | mov    word ptr [ebp - 0x1c0], 0x20c
            //   ba????????           |                     
            //   8d8544ffffff         | lea                 eax, [ebp - 0xbc]

        $sequence_4 = { 8d850cffffff ba02000000 e8???????? 66c785b0feffffb402 ba???????? 8d8508ffffff e8???????? }
            // n = 7, score = 100
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   66c785b0feffffb402     | mov    word ptr [ebp - 0x150], 0x2b4
            //   ba????????           |                     
            //   8d8508ffffff         | lea                 eax, [ebp - 0xf8]
            //   e8????????           |                     

        $sequence_5 = { 6683f822 7407 8bc3 e8???????? 5b c3 80b8ec01000001 }
            // n = 7, score = 100
            //   6683f822             | cmp                 ax, 0x22
            //   7407                 | je                  9
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   80b8ec01000001       | cmp                 byte ptr [eax + 0x1ec], 1

        $sequence_6 = { e8???????? ff4df8 ff4df8 6a00 68???????? e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   ff4df8               | dec                 dword ptr [ebp - 8]
            //   ff4df8               | dec                 dword ptr [ebp - 8]
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { e8???????? 8b500c 8d45f8 e8???????? 8b45f8 50 8b8378010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b500c               | mov                 edx, dword ptr [eax + 0xc]
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   50                   | push                eax
            //   8b8378010000         | mov                 eax, dword ptr [ebx + 0x178]

        $sequence_8 = { ff8de8feffff 8d45cc ba02000000 e8???????? 66c785dcfeffff7400 ba???????? 8d45c8 }
            // n = 7, score = 100
            //   ff8de8feffff         | dec                 dword ptr [ebp - 0x118]
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   66c785dcfeffff7400     | mov    word ptr [ebp - 0x124], 0x74
            //   ba????????           |                     
            //   8d45c8               | lea                 eax, [ebp - 0x38]

        $sequence_9 = { 7506 803f00 7401 47 8b4508 8978fc 5f }
            // n = 7, score = 100
            //   7506                 | jne                 8
            //   803f00               | cmp                 byte ptr [edi], 0
            //   7401                 | je                  3
            //   47                   | inc                 edi
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8978fc               | mov                 dword ptr [eax - 4], edi
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 3325952
}