rule win_navrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.navrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.navrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1e610 0bf0 56 e8???????? }
            // n = 4, score = 300
            //   c1e610               | shl                 esi, 0x10
            //   0bf0                 | or                  esi, eax
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_1 = { 7707 0fbec0 83e847 c3 8d48d0 80f909 }
            // n = 6, score = 300
            //   7707                 | ja                  9
            //   0fbec0               | movsx               eax, al
            //   83e847               | sub                 eax, 0x47
            //   c3                   | ret                 
            //   8d48d0               | lea                 ecx, [eax - 0x30]
            //   80f909               | cmp                 cl, 9

        $sequence_2 = { 1bf6 f7de 56 68???????? e8???????? }
            // n = 5, score = 300
            //   1bf6                 | sbb                 esi, esi
            //   f7de                 | neg                 esi
            //   56                   | push                esi
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 8d48bf 80f919 7707 0fbec0 83e841 }
            // n = 5, score = 300
            //   8d48bf               | lea                 ecx, [eax - 0x41]
            //   80f919               | cmp                 cl, 0x19
            //   7707                 | ja                  9
            //   0fbec0               | movsx               eax, al
            //   83e841               | sub                 eax, 0x41

        $sequence_4 = { 8d85a4feffff 50 6801000080 ff15???????? }
            // n = 4, score = 300
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]
            //   50                   | push                eax
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     

        $sequence_5 = { 56 50 57 a3???????? ff15???????? 57 ff15???????? }
            // n = 7, score = 300
            //   56                   | push                esi
            //   50                   | push                eax
            //   57                   | push                edi
            //   a3????????           |                     
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_6 = { 0fbec0 83e847 c3 8d48d0 80f909 7707 }
            // n = 6, score = 300
            //   0fbec0               | movsx               eax, al
            //   83e847               | sub                 eax, 0x47
            //   c3                   | ret                 
            //   8d48d0               | lea                 ecx, [eax - 0x30]
            //   80f909               | cmp                 cl, 9
            //   7707                 | ja                  9

        $sequence_7 = { 7503 884702 85f6 7407 8b7608 }
            // n = 5, score = 300
            //   7503                 | jne                 5
            //   884702               | mov                 byte ptr [edi + 2], al
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   8b7608               | mov                 esi, dword ptr [esi + 8]

        $sequence_8 = { fec8 2440 fec8 c3 }
            // n = 4, score = 300
            //   fec8                 | dec                 al
            //   2440                 | and                 al, 0x40
            //   fec8                 | dec                 al
            //   c3                   | ret                 

        $sequence_9 = { 884702 85f6 7407 8b7608 }
            // n = 4, score = 300
            //   884702               | mov                 byte ptr [edi + 2], al
            //   85f6                 | test                esi, esi
            //   7407                 | je                  9
            //   8b7608               | mov                 esi, dword ptr [esi + 8]

    condition:
        7 of them and filesize < 352256
}