rule win_neconyd_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.neconyd."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neconyd"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 74c7 ff75fc 8d85f0efffff 50 8d0437 50 }
            // n = 6, score = 100
            //   74c7                 | je                  0xffffffc9
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d85f0efffff         | lea                 eax, [ebp - 0x1010]
            //   50                   | push                eax
            //   8d0437               | lea                 eax, [edi + esi]
            //   50                   | push                eax

        $sequence_1 = { c6466701 c6466804 89460c 894e60 397d18 0f85b0000000 8b15???????? }
            // n = 7, score = 100
            //   c6466701             | mov                 byte ptr [esi + 0x67], 1
            //   c6466804             | mov                 byte ptr [esi + 0x68], 4
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   894e60               | mov                 dword ptr [esi + 0x60], ecx
            //   397d18               | cmp                 dword ptr [ebp + 0x18], edi
            //   0f85b0000000         | jne                 0xb6
            //   8b15????????         |                     

        $sequence_2 = { c6466500 c6466b00 c6466c00 8b442418 898680000000 33c0 }
            // n = 6, score = 100
            //   c6466500             | mov                 byte ptr [esi + 0x65], 0
            //   c6466b00             | mov                 byte ptr [esi + 0x6b], 0
            //   c6466c00             | mov                 byte ptr [esi + 0x6c], 0
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   898680000000         | mov                 dword ptr [esi + 0x80], eax
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { c3 56 66c7003000 57 40 40 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   56                   | push                esi
            //   66c7003000           | mov                 word ptr [eax], 0x30
            //   57                   | push                edi
            //   40                   | inc                 eax
            //   40                   | inc                 eax

        $sequence_4 = { 8365fc00 8d45fc 50 6a27 6a5e 8d45d4 }
            // n = 6, score = 100
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a27                 | push                0x27
            //   6a5e                 | push                0x5e
            //   8d45d4               | lea                 eax, [ebp - 0x2c]

        $sequence_5 = { 57 bb???????? 50 8bd3 e8???????? b9???????? }
            // n = 6, score = 100
            //   57                   | push                edi
            //   bb????????           |                     
            //   50                   | push                eax
            //   8bd3                 | mov                 edx, ebx
            //   e8????????           |                     
            //   b9????????           |                     

        $sequence_6 = { 66c745ae5814 66c745b0d104 66c745b2c19d 66c745b42070 66c745b66afc 66c745b88fed }
            // n = 6, score = 100
            //   66c745ae5814         | mov                 word ptr [ebp - 0x52], 0x1458
            //   66c745b0d104         | mov                 word ptr [ebp - 0x50], 0x4d1
            //   66c745b2c19d         | mov                 word ptr [ebp - 0x4e], 0x9dc1
            //   66c745b42070         | mov                 word ptr [ebp - 0x4c], 0x7020
            //   66c745b66afc         | mov                 word ptr [ebp - 0x4a], 0xfc6a
            //   66c745b88fed         | mov                 word ptr [ebp - 0x48], 0xed8f

        $sequence_7 = { eb06 81c1ffff0000 880e 46 ff45fc }
            // n = 5, score = 100
            //   eb06                 | jmp                 8
            //   81c1ffff0000         | add                 ecx, 0xffff
            //   880e                 | mov                 byte ptr [esi], cl
            //   46                   | inc                 esi
            //   ff45fc               | inc                 dword ptr [ebp - 4]

        $sequence_8 = { 29450c 83c40c 03f0 8d45fc 50 6800100000 8d85f0efffff }
            // n = 7, score = 100
            //   29450c               | sub                 dword ptr [ebp + 0xc], eax
            //   83c40c               | add                 esp, 0xc
            //   03f0                 | add                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6800100000           | push                0x1000
            //   8d85f0efffff         | lea                 eax, [ebp - 0x1010]

        $sequence_9 = { 394d18 0f8d35010000 8b0d???????? 3bcf 750c 66c745d83000 }
            // n = 6, score = 100
            //   394d18               | cmp                 dword ptr [ebp + 0x18], ecx
            //   0f8d35010000         | jge                 0x13b
            //   8b0d????????         |                     
            //   3bcf                 | cmp                 ecx, edi
            //   750c                 | jne                 0xe
            //   66c745d83000         | mov                 word ptr [ebp - 0x28], 0x30

    condition:
        7 of them and filesize < 326182
}