rule win_neddnloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.neddnloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neddnloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 ff15???????? 8b4df8 56 3bc8 }
            // n = 5, score = 400
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   56                   | push                esi
            //   3bc8                 | cmp                 ecx, eax

        $sequence_1 = { 8d43ff 3bc8 7311 0fb702 0fb731 663bc6 }
            // n = 6, score = 400
            //   8d43ff               | lea                 eax, [ebx - 1]
            //   3bc8                 | cmp                 ecx, eax
            //   7311                 | jae                 0x13
            //   0fb702               | movzx               eax, word ptr [edx]
            //   0fb731               | movzx               esi, word ptr [ecx]
            //   663bc6               | cmp                 ax, si

        $sequence_2 = { 8b03 8b5508 69c0b179379e c1e813 33c9 }
            // n = 5, score = 400
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   69c0b179379e         | imul                eax, eax, 0x9e3779b1
            //   c1e813               | shr                 eax, 0x13
            //   33c9                 | xor                 ecx, ecx

        $sequence_3 = { 0fb731 663bc6 7506 83c102 83c202 }
            // n = 5, score = 400
            //   0fb731               | movzx               esi, word ptr [ecx]
            //   663bc6               | cmp                 ax, si
            //   7506                 | jne                 8
            //   83c102               | add                 ecx, 2
            //   83c202               | add                 edx, 2

        $sequence_4 = { 83c204 3bcf 72f0 8d43ff 3bc8 7311 }
            // n = 6, score = 400
            //   83c204               | add                 edx, 4
            //   3bcf                 | cmp                 ecx, edi
            //   72f0                 | jb                  0xfffffff2
            //   8d43ff               | lea                 eax, [ebx - 1]
            //   3bc8                 | cmp                 ecx, eax
            //   7311                 | jae                 0x13

        $sequence_5 = { eb02 0008 8b45f8 83c0f4 }
            // n = 4, score = 400
            //   eb02                 | jmp                 4
            //   0008                 | add                 byte ptr [eax], cl
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83c0f4               | add                 eax, -0xc

        $sequence_6 = { 57 e8???????? 2b5d10 83c40c }
            // n = 4, score = 400
            //   57                   | push                edi
            //   e8????????           |                     
            //   2b5d10               | sub                 ebx, dword ptr [ebp + 0x10]
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { 8d84241c040000 50 68???????? b900230400 }
            // n = 4, score = 400
            //   8d84241c040000       | lea                 eax, [esp + 0x41c]
            //   50                   | push                eax
            //   68????????           |                     
            //   b900230400           | mov                 ecx, 0x42300

        $sequence_8 = { 4133bc8e803c0100 4133bc8680480100 418bc0 41337d20 c1e808 0fb6d0 418bc1 }
            // n = 7, score = 100
            //   4133bc8e803c0100     | xor                 eax, dword ptr [esp + eax*4 + 0x15580]
            //   4133bc8680480100     | sete                al
            //   418bc0               | mov                 dword ptr [esp + 0x4c], eax
            //   41337d20             | dec                 eax
            //   c1e808               | lea                 eax, [0xefca]
            //   0fb6d0               | dec                 edx
            //   418bc1               | mov                 edx, dword ptr [eax]

        $sequence_9 = { 488d0587930000 483bc8 7405 e8???????? bf0d000000 }
            // n = 5, score = 100
            //   488d0587930000       | dec                 eax
            //   483bc8               | lea                 eax, [0x9387]
            //   7405                 | dec                 eax
            //   e8????????           |                     
            //   bf0d000000           | cmp                 ecx, eax

        $sequence_10 = { 4533948480590100 458b848c804d0100 410fb6c1 4533848480510100 45335538 410fb6c3 4533848480550100 }
            // n = 7, score = 100
            //   4533948480590100     | dec                 ecx
            //   458b848c804d0100     | mov                 ecx, ecx
            //   410fb6c1             | inc                 esp
            //   4533848480510100     | xor                 eax, eax
            //   45335538             | inc                 eax
            //   410fb6c3             | movzx               eax, bh
            //   4533848480550100     | inc                 edx

        $sequence_11 = { 440fb68c29804c0100 c1e810 0fb6c8 41c1e108 0fb68429804c0100 4433c8 }
            // n = 6, score = 100
            //   440fb68c29804c0100     | inc    ebp
            //   c1e810               | mov                 eax, dword ptr [esp + ecx*4 + 0x14d80]
            //   0fb6c8               | inc                 ecx
            //   41c1e108             | movzx               eax, cl
            //   0fb68429804c0100     | inc                 ebp
            //   4433c8               | xor                 eax, dword ptr [esp + eax*4 + 0x15180]

        $sequence_12 = { 410fb6c2 41339c8480440100 45337508 410fb6c3 41339c8480400100 }
            // n = 5, score = 100
            //   410fb6c2             | inc                 ebp
            //   41339c8480440100     | xor                 edx, dword ptr [ebp + 0x38]
            //   45337508             | inc                 ecx
            //   410fb6c3             | movzx               eax, bl
            //   41339c8480400100     | inc                 ebp

        $sequence_13 = { 4433c0 400fb6c7 420fb68420803b0100 41c1e008 }
            // n = 4, score = 100
            //   4433c0               | dec                 esp
            //   400fb6c7             | mov                 eax, ecx
            //   420fb68420803b0100     | dec    esp
            //   41c1e008             | lea                 ecx, [0xffff0ef2]

        $sequence_14 = { 4883ec28 4c8bc1 4c8d0df20effff 498bc9 e8???????? }
            // n = 5, score = 100
            //   4883ec28             | je                  7
            //   4c8bc1               | mov                 edi, 0xd
            //   4c8d0df20effff       | dec                 eax
            //   498bc9               | sub                 esp, 0x28
            //   e8????????           |                     

        $sequence_15 = { 0f94c0 8944244c 488d05caef0000 4a8b14e0 41837c175000 }
            // n = 5, score = 100
            //   0f94c0               | movzx               eax, byte ptr [eax + 0x13b80]
            //   8944244c             | inc                 ecx
            //   488d05caef0000       | shl                 eax, 8
            //   4a8b14e0             | inc                 ebp
            //   41837c175000         | xor                 edx, dword ptr [esp + eax*4 + 0x15980]

    condition:
        7 of them and filesize < 3438592
}