rule win_nemty_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.nemty."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nemty"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6bf61c 8b45e8 03f0 897308 6bff1c }
            // n = 5, score = 300
            //   6bf61c               | imul                esi, esi, 0x1c
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   03f0                 | add                 esi, eax
            //   897308               | mov                 dword ptr [ebx + 8], esi
            //   6bff1c               | imul                edi, edi, 0x1c

        $sequence_1 = { e8???????? 53 8d75e0 e8???????? 8b4dfc 5f 5e }
            // n = 7, score = 300
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8d75e0               | lea                 esi, [ebp - 0x20]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { e8???????? 6a01 33ff 8d7508 e8???????? 8b4dfc }
            // n = 6, score = 300
            //   e8????????           |                     
            //   6a01                 | push                1
            //   33ff                 | xor                 edi, edi
            //   8d7508               | lea                 esi, [ebp + 8]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_3 = { 83c61c 3bd8 72c0 68???????? }
            // n = 4, score = 300
            //   83c61c               | add                 esi, 0x1c
            //   3bd8                 | cmp                 ebx, eax
            //   72c0                 | jb                  0xffffffc2
            //   68????????           |                     

        $sequence_4 = { ff15???????? 53 8d459c 50 ff35???????? }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   8d459c               | lea                 eax, [ebp - 0x64]
            //   50                   | push                eax
            //   ff35????????         |                     

        $sequence_5 = { e8???????? 33db 43 53 33ff 8d75e0 e8???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx
            //   53                   | push                ebx
            //   33ff                 | xor                 edi, edi
            //   8d75e0               | lea                 esi, [ebp - 0x20]
            //   e8????????           |                     

        $sequence_6 = { c20400 8b4f04 53 8bd8 56 }
            // n = 5, score = 300
            //   c20400               | ret                 4
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   53                   | push                ebx
            //   8bd8                 | mov                 ebx, eax
            //   56                   | push                esi

        $sequence_7 = { 5f f7ff 43 83c61c 3bd8 72c0 }
            // n = 6, score = 300
            //   5f                   | pop                 edi
            //   f7ff                 | idiv                edi
            //   43                   | inc                 ebx
            //   83c61c               | add                 esi, 0x1c
            //   3bd8                 | cmp                 ebx, eax
            //   72c0                 | jb                  0xffffffc2

        $sequence_8 = { 837d3810 8bf8 8b4524 59 7303 8d4524 837d3810 }
            // n = 7, score = 300
            //   837d3810             | cmp                 dword ptr [ebp + 0x38], 0x10
            //   8bf8                 | mov                 edi, eax
            //   8b4524               | mov                 eax, dword ptr [ebp + 0x24]
            //   59                   | pop                 ecx
            //   7303                 | jae                 5
            //   8d4524               | lea                 eax, [ebp + 0x24]
            //   837d3810             | cmp                 dword ptr [ebp + 0x38], 0x10

        $sequence_9 = { 50 56 6806000200 6a01 56 56 68???????? }
            // n = 7, score = 300
            //   50                   | push                eax
            //   56                   | push                esi
            //   6806000200           | push                0x20006
            //   6a01                 | push                1
            //   56                   | push                esi
            //   56                   | push                esi
            //   68????????           |                     

    condition:
        7 of them and filesize < 204800
}