rule win_net_star_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.net_star."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.net_star"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 281f00000a 1106 281e00000a dc 1109 6f2500000a 1109 }
            // n = 7, score = 100
            //   281f00000a           | jle                 0x1f
            //   1106                 | add                 byte ptr [eax], al
            //   281e00000a           | or                  ch, byte ptr [eax]
            //   dc                   | sldt                word ptr [eax]
            //   1109                 | or                  al, byte ptr [ebx]
            //   6f2500000a           | jb                  0x1d
            //   1109                 | add                 byte ptr [eax], al

        $sequence_1 = { 6f2400000a 6f2200000a de0f 1107 281f00000a }
            // n = 5, score = 100
            //   6f2400000a           | or                  dword ptr [edi + 0x21], ebp
            //   6f2200000a           | add                 byte ptr [eax], al
            //   de0f                 | or                  ch, byte ptr [eax]
            //   1107                 | add                 dword ptr [eax], eax
            //   281f00000a           | add                 byte ptr [esi], al

        $sequence_2 = { 728d000070 2a 07 2802000006 1305 281a00000a }
            // n = 6, score = 100
            //   728d000070           | sub                 byte ptr [edi], bl
            //   2a                   | add                 byte ptr [eax], al
            //   07                   | or                  dl, byte ptr [edx]
            //   2802000006           | add                 byte ptr [eax], ch
            //   1305                 | add                 dword ptr [eax], eax
            //   281a00000a           | add                 byte ptr [esi], al

        $sequence_3 = { 740100001b 0c 03 7243000070 6f1500000a }
            // n = 5, score = 100
            //   740100001b           | or                  ch, byte ptr [edi + 0x19]
            //   0c                   | add                 byte ptr [eax], al
            //   03                   | or                  dl, byte ptr [ebx]
            //   7243000070           | add                 al, 0x11
            //   6f1500000a           | add                 al, 0x2d

        $sequence_4 = { 1308 1108 731d00000a 1309 1109 }
            // n = 5, score = 100
            //   1308                 | add                 byte ptr [eax], al
            //   1108                 | jo                  0xeb
            //   731d00000a           | adc                 eax, 0x740a0000
            //   1309                 | add                 dword ptr [eax], eax
            //   1109                 | add                 byte ptr [ebx], bl

        $sequence_5 = { 09 281100000a 5a 281200000a 1304 08 09 }
            // n = 7, score = 100
            //   09                   | add                 byte ptr [eax], al
            //   281100000a           | or                  ch, byte ptr [edi + 0x19]
            //   5a                   | add                 byte ptr [eax], al
            //   281200000a           | or                  dl, byte ptr [ebx]
            //   1304                 | add                 al, 0x11
            //   08                   | add                 al, 0x2b
            //   09                   | sbb                 eax, 0x11280907

        $sequence_6 = { 08 09 1104 281300000a a2 09 }
            // n = 6, score = 100
            //   08                   | add                 esi, dword ptr [edx + 0x29]
            //   09                   | add                 byte ptr [eax], al
            //   1104                 | jo                  0x9e
            //   281300000a           | adc                 eax, 0x6f0a0000
            //   a2                   | pop                 ss
            //   09                   | add                 byte ptr [eax], al

        $sequence_7 = { 6f1700000a 6f1500000a 740100001b 0d 09 2d06 725f000070 }
            // n = 7, score = 100
            //   6f1700000a           | add                 byte ptr [eax], al
            //   6f1500000a           | or                  dl, byte ptr [ebx]
            //   740100001b           | add                 al, 0x11
            //   0d                   | add                 al, 0x2d
            //   09                   | push                es
            //   2d06                 | jb                  0xffffffb9
            //   725f000070           | add                 byte ptr [eax], al

        $sequence_8 = { 09 08 8e 69 32dd 08 }
            // n = 6, score = 100
            //   09                   | or                  ch, byte ptr [edi + 0x21]
            //   08                   | add                 byte ptr [eax], al
            //   8e                   | or                  dl, byte ptr [ecx]
            //   69                   | or                  dword ptr [edx - 0x1b], esi
            //   32dd                 | add                 byte ptr [eax], al
            //   08                   | jo                  0xef

        $sequence_9 = { 26 de49 130a 1109 6f2100000a 1109 }
            // n = 6, score = 100
            //   26                   | add                 byte ptr [eax], al
            //   de49                 | or                  cl, byte ptr [eax]
            //   130a                 | outsd               dx, dword ptr [esi]
            //   1109                 | pop                 ss
            //   6f2100000a           | add                 byte ptr [eax], al
            //   1109                 | or                  ch, byte ptr [edi + 0x15]

    condition:
        7 of them and filesize < 50176
}