rule win_neteagle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.neteagle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.neteagle"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b86040c0000 40 8d0c40 c704ce02000000 e9???????? 8b54242c }
            // n = 6, score = 100
            //   8b86040c0000         | mov                 eax, dword ptr [esi + 0xc04]
            //   40                   | inc                 eax
            //   8d0c40               | lea                 ecx, [eax + eax*2]
            //   c704ce02000000       | mov                 dword ptr [esi + ecx*8], 2
            //   e9????????           |                     
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]

        $sequence_1 = { 8b4c241c 52 53 50 51 ff15???????? 85c0 }
            // n = 7, score = 100
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   52                   | push                edx
            //   53                   | push                ebx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 8b461c 85c0 0f849e010000 8bce e8???????? 85c0 0f848f010000 }
            // n = 7, score = 100
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   85c0                 | test                eax, eax
            //   0f849e010000         | je                  0x1a4
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f848f010000         | je                  0x195

        $sequence_3 = { 8bf8 6804010000 897c2424 c744242804010000 c744242c01000000 e8???????? 8b8c2464010000 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   6804010000           | push                0x104
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi
            //   c744242804010000     | mov                 dword ptr [esp + 0x28], 0x104
            //   c744242c01000000     | mov                 dword ptr [esp + 0x2c], 1
            //   e8????????           |                     
            //   8b8c2464010000       | mov                 ecx, dword ptr [esp + 0x164]

        $sequence_4 = { 8b4b24 03c8 89542901 8b4b24 8b542438 03c8 89542905 }
            // n = 7, score = 100
            //   8b4b24               | mov                 ecx, dword ptr [ebx + 0x24]
            //   03c8                 | add                 ecx, eax
            //   89542901             | mov                 dword ptr [ecx + ebp + 1], edx
            //   8b4b24               | mov                 ecx, dword ptr [ebx + 0x24]
            //   8b542438             | mov                 edx, dword ptr [esp + 0x38]
            //   03c8                 | add                 ecx, eax
            //   89542905             | mov                 dword ptr [ecx + ebp + 5], edx

        $sequence_5 = { 6a17 50 8bcb e8???????? 8d4da0 6a0f 8d55e0 }
            // n = 7, score = 100
            //   6a17                 | push                0x17
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   6a0f                 | push                0xf
            //   8d55e0               | lea                 edx, [ebp - 0x20]

        $sequence_6 = { e8???????? 8b470c 83c604 8b0430 85c0 75e1 33f6 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   83c604               | add                 esi, 4
            //   8b0430               | mov                 eax, dword ptr [eax + esi]
            //   85c0                 | test                eax, eax
            //   75e1                 | jne                 0xffffffe3
            //   33f6                 | xor                 esi, esi

        $sequence_7 = { a1???????? 83f801 7f82 5f 5e 5b 8b4dfc }
            // n = 7, score = 100
            //   a1????????           |                     
            //   83f801               | cmp                 eax, 1
            //   7f82                 | jg                  0xffffff84
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_8 = { 68???????? 52 ffd5 83c408 8d4c2440 85c0 0f94c3 }
            // n = 7, score = 100
            //   68????????           |                     
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   83c408               | add                 esp, 8
            //   8d4c2440             | lea                 ecx, [esp + 0x40]
            //   85c0                 | test                eax, eax
            //   0f94c3               | sete                bl

        $sequence_9 = { 894d98 8b8de4feffff 89559c 8945a0 8d95e8feffff 6a64 8d45d8 }
            // n = 7, score = 100
            //   894d98               | mov                 dword ptr [ebp - 0x68], ecx
            //   8b8de4feffff         | mov                 ecx, dword ptr [ebp - 0x11c]
            //   89559c               | mov                 dword ptr [ebp - 0x64], edx
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   8d95e8feffff         | lea                 edx, [ebp - 0x118]
            //   6a64                 | push                0x64
            //   8d45d8               | lea                 eax, [ebp - 0x28]

    condition:
        7 of them and filesize < 262144
}