rule win_netkey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.netkey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netkey"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bca 0fa4c103 c1e003 03f0 13d1 0fa4f202 c1e602 }
            // n = 7, score = 200
            //   8bca                 | mov                 ecx, edx
            //   0fa4c103             | shld                ecx, eax, 3
            //   c1e003               | shl                 eax, 3
            //   03f0                 | add                 esi, eax
            //   13d1                 | adc                 edx, ecx
            //   0fa4f202             | shld                edx, esi, 2
            //   c1e602               | shl                 esi, 2

        $sequence_1 = { 786d 8b4d08 8bd6 e8???????? 85c0 }
            // n = 5, score = 200
            //   786d                 | js                  0x6f
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8bd6                 | mov                 edx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 83fa03 7511 8b45fc 8b0c85a8214400 8a06 }
            // n = 5, score = 200
            //   83fa03               | cmp                 edx, 3
            //   7511                 | jne                 0x13
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b0c85a8214400       | mov                 ecx, dword ptr [eax*4 + 0x4421a8]
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_3 = { 83c40c 8d85f0dfffff 6800080000 50 6a00 56 ff15???????? }
            // n = 7, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8d85f0dfffff         | lea                 eax, [ebp - 0x2010]
            //   6800080000           | push                0x800
            //   50                   | push                eax
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_4 = { 83e10f eb02 33c9 8b450c 0fb684c8b02e4300 c1e804 }
            // n = 6, score = 200
            //   83e10f               | and                 ecx, 0xf
            //   eb02                 | jmp                 4
            //   33c9                 | xor                 ecx, ecx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0fb684c8b02e4300     | movzx               eax, byte ptr [eax + ecx*8 + 0x432eb0]
            //   c1e804               | shr                 eax, 4

        $sequence_5 = { 05b0407c05 3146e8 8b4714 059ea0eb01 3146ec 8b4718 05???????? }
            // n = 7, score = 200
            //   05b0407c05           | add                 eax, 0x57c40b0
            //   3146e8               | xor                 dword ptr [esi - 0x18], eax
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   059ea0eb01           | add                 eax, 0x1eba09e
            //   3146ec               | xor                 dword ptr [esi - 0x14], eax
            //   8b4718               | mov                 eax, dword ptr [edi + 0x18]
            //   05????????           |                     

        $sequence_6 = { 8b95b4efffff 46 8985f8efffff 8bc2 c1e802 40 3bf0 }
            // n = 7, score = 200
            //   8b95b4efffff         | mov                 edx, dword ptr [ebp - 0x104c]
            //   46                   | inc                 esi
            //   8985f8efffff         | mov                 dword ptr [ebp - 0x1008], eax
            //   8bc2                 | mov                 eax, edx
            //   c1e802               | shr                 eax, 2
            //   40                   | inc                 eax
            //   3bf0                 | cmp                 esi, eax

        $sequence_7 = { e8???????? 51 e8???????? a3???????? 85c0 7974 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   7974                 | jns                 0x76

        $sequence_8 = { 8bc1 c1f806 83e13f 6bc930 8b0485a8214400 80640828fe ff36 }
            // n = 7, score = 200
            //   8bc1                 | mov                 eax, ecx
            //   c1f806               | sar                 eax, 6
            //   83e13f               | and                 ecx, 0x3f
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8b0485a8214400       | mov                 eax, dword ptr [eax*4 + 0x4421a8]
            //   80640828fe           | and                 byte ptr [eax + ecx + 0x28], 0xfe
            //   ff36                 | push                dword ptr [esi]

        $sequence_9 = { 3a4801 751c 83c702 83c002 84c9 75e4 }
            // n = 6, score = 200
            //   3a4801               | cmp                 cl, byte ptr [eax + 1]
            //   751c                 | jne                 0x1e
            //   83c702               | add                 edi, 2
            //   83c002               | add                 eax, 2
            //   84c9                 | test                cl, cl
            //   75e4                 | jne                 0xffffffe6

    condition:
        7 of them and filesize < 606208
}