rule win_netrepser_keylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.netrepser_keylogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.netrepser_keylogger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ff15???????? 8b550c 8902 8b450c 833800 742b }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8902                 | mov                 dword ptr [edx], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   833800               | cmp                 dword ptr [eax], 0
            //   742b                 | je                  0x2d

        $sequence_1 = { 51 8b5510 8b02 50 e8???????? 83f8ff 7507 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7507                 | jne                 9

        $sequence_2 = { 895108 8b4538 89410c 8b553c 895110 8b4528 50 }
            // n = 7, score = 200
            //   895108               | mov                 dword ptr [ecx + 8], edx
            //   8b4538               | mov                 eax, dword ptr [ebp + 0x38]
            //   89410c               | mov                 dword ptr [ecx + 0xc], eax
            //   8b553c               | mov                 edx, dword ptr [ebp + 0x3c]
            //   895110               | mov                 dword ptr [ecx + 0x10], edx
            //   8b4528               | mov                 eax, dword ptr [ebp + 0x28]
            //   50                   | push                eax

        $sequence_3 = { 8b45e4 8945c0 eb07 c745c000000000 }
            // n = 4, score = 200
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   eb07                 | jmp                 9
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0

        $sequence_4 = { 833d????????00 0f85ab000000 c645dc53 c645dd48 }
            // n = 4, score = 200
            //   833d????????00       |                     
            //   0f85ab000000         | jne                 0xb1
            //   c645dc53             | mov                 byte ptr [ebp - 0x24], 0x53
            //   c645dd48             | mov                 byte ptr [ebp - 0x23], 0x48

        $sequence_5 = { 81ec3c010000 6804010000 8d85e0feffff 50 6a00 ff15???????? }
            // n = 6, score = 200
            //   81ec3c010000         | sub                 esp, 0x13c
            //   6804010000           | push                0x104
            //   8d85e0feffff         | lea                 eax, [ebp - 0x120]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_6 = { 8d4310 8d89245b4100 5a 668b31 41 668930 41 }
            // n = 7, score = 200
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   8d89245b4100         | lea                 ecx, [ecx + 0x415b24]
            //   5a                   | pop                 edx
            //   668b31               | mov                 si, word ptr [ecx]
            //   41                   | inc                 ecx
            //   668930               | mov                 word ptr [eax], si
            //   41                   | inc                 ecx

        $sequence_7 = { e9???????? c645cc44 c645cd41 c645ce54 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   c645cc44             | mov                 byte ptr [ebp - 0x34], 0x44
            //   c645cd41             | mov                 byte ptr [ebp - 0x33], 0x41
            //   c645ce54             | mov                 byte ptr [ebp - 0x32], 0x54

        $sequence_8 = { 8b701c 8bcf e8???????? 8b4c240c 0fb711 }
            // n = 5, score = 100
            //   8b701c               | mov                 esi, dword ptr [eax + 0x1c]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   0fb711               | movzx               edx, word ptr [ecx]

        $sequence_9 = { c74424104c6f6164 c74424144c696272 c744241861727941 8974241c ff15???????? 8bc8 }
            // n = 6, score = 100
            //   c74424104c6f6164     | mov                 dword ptr [esp + 0x10], 0x64616f4c
            //   c74424144c696272     | mov                 dword ptr [esp + 0x14], 0x7262694c
            //   c744241861727941     | mov                 dword ptr [esp + 0x18], 0x41797261
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_10 = { 8b4d18 8d7520 e8???????? 83c418 85c0 }
            // n = 5, score = 100
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8d7520               | lea                 esi, [ebp + 0x20]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax

        $sequence_11 = { 8b0d???????? 51 e8???????? 8b442430 8b542414 8910 83c404 }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8910                 | mov                 dword ptr [eax], edx
            //   83c404               | add                 esp, 4

        $sequence_12 = { ff15???????? a3???????? 8b542448 6a40 6800300000 52 6a00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   a3????????           |                     
            //   8b542448             | mov                 edx, dword ptr [esp + 0x48]
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_13 = { 3bc5 7d08 5d 33c0 5b 83c418 }
            // n = 6, score = 100
            //   3bc5                 | cmp                 eax, ebp
            //   7d08                 | jge                 0xa
            //   5d                   | pop                 ebp
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   83c418               | add                 esp, 0x18

        $sequence_14 = { 85c0 750d 8b442418 e8???????? 85c0 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_15 = { 81c408010000 c3 8bff 55 8bec }
            // n = 5, score = 100
            //   81c408010000         | add                 esp, 0x108
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

    condition:
        7 of them and filesize < 303104
}